/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.helpers.validation.xml;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.polarsys.capella.common.helpers.HelperPlugin;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLValidationHelper {
    protected SAXParser parser;
    protected DefaultHandler defaultHandler;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public XMLValidationHelper() {
        try {
            try {
                this.parser = SAXParserFactory.newInstance().newSAXParser();
                return;
            }
            catch (ParserConfigurationException exception) {
                HelperPlugin.getDefault().getLog().log((IStatus)new Status(4, HelperPlugin.getDefault().getPluginId(), exception.getMessage(), (Throwable)exception));
                if (this.parser != null) return;
                throw new RuntimeException("Cannot get a SAXParser instance");
            }
            catch (SAXException exception) {
                HelperPlugin.getDefault().getLog().log((IStatus)new Status(4, HelperPlugin.getDefault().getPluginId(), exception.getMessage(), (Throwable)exception));
                if (this.parser != null) return;
                throw new RuntimeException("Cannot get a SAXParser instance");
            }
        }
        finally {
            if (this.parser == null) {
                throw new RuntimeException("Cannot get a SAXParser instance");
            }
        }
    }

    public List<SAXParseException> checkWellFormed(String text) {
        SAXExceptions handler;
        block3: {
            handler = new SAXExceptions();
            try {
                this.parser.parse(new InputSource(new StringReader(text)), (DefaultHandler)handler);
            }
            catch (IOException exception) {
                HelperPlugin.getDefault().getLog().log((IStatus)new Status(4, HelperPlugin.getDefault().getPluginId(), exception.getMessage(), (Throwable)exception));
            }
            catch (SAXException exception) {
                if (exception instanceof SAXParseException) break block3;
                HelperPlugin.getDefault().getLog().log((IStatus)new Status(4, HelperPlugin.getDefault().getPluginId(), exception.getMessage(), (Throwable)exception));
            }
        }
        return handler.getExceptions();
    }

    class SAXExceptions
    extends DefaultHandler {
        protected List<SAXParseException> exceptions = new ArrayList<SAXParseException>();

        SAXExceptions() {
        }

        @Override
        public void error(SAXParseException e) {
            this.exceptions.add(e);
        }

        @Override
        public void fatalError(SAXParseException e) {
            this.exceptions.add(e);
        }

        public List<SAXParseException> getExceptions() {
            return this.exceptions;
        }
    }
}

