/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.scenario.topdown;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.epbs.ConfigurationItem;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.information.ExchangeItemInstance;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.data.interaction.AbstractEnd;
import org.polarsys.capella.core.data.interaction.Event;
import org.polarsys.capella.core.data.interaction.ExecutionEnd;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.InteractionFragment;
import org.polarsys.capella.core.data.interaction.MessageEnd;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.data.oa.Role;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.model.helpers.AbstractFunctionExt;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentExchangeExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.FunctionalExchangeExt;
import org.polarsys.capella.core.model.helpers.RefinementLinkExt;
import org.polarsys.capella.core.model.utils.ListExt;
import org.polarsys.capella.core.projection.common.TransitionHelper;
import org.polarsys.capella.core.projection.common.resolver.ResolverFinalizer;
import org.polarsys.capella.core.projection.scenario.Messages;
import org.polarsys.capella.core.projection.scenario.ScenarioTransfo;
import org.polarsys.capella.core.projection.scenario.helpers.ScenarioExt;
import org.polarsys.capella.core.projection.scenario.helpers.UnwantedObjects;
import org.polarsys.capella.core.tiger.ITransfo;
import org.polarsys.capella.core.tiger.helpers.Query;

public class TopDownExt {
    public static List<AbstractInstance> getTargetInstances(Scenario scenario, ITransfo transfo_p) {
        ArrayList<AbstractInstance> partBounds = new ArrayList();
        for (InteractionFragment fragment : scenario.getOwnedInteractionFragments()) {
            if (!(fragment instanceof AbstractEnd)) continue;
            AbstractEnd end = (AbstractEnd)fragment;
            AbstractEventOperation transitionedOperation = TopDownExt.getTransitionedOperation((EObject)end, transfo_p);
            boolean isSource = ScenarioExt.isSource(end);
            AbstractInstance instance = TopDownExt.getTargetInstance(isSource, end, transitionedOperation, transfo_p);
            if (instance == null) continue;
            partBounds.add(instance);
        }
        partBounds = ListExt.removeDuplicates(partBounds);
        return partBounds;
    }

    public static List<AbstractInstance> getTargetInstances(InstanceRole role, ITransfo transfo_p) {
        ArrayList<AbstractInstance> partBounds = new ArrayList();
        for (AbstractEnd end : role.getAbstractEnds()) {
            AbstractEventOperation transitionedOperation = TopDownExt.getTransitionedOperation((EObject)end, transfo_p);
            boolean isSource = ScenarioExt.isSource(end);
            AbstractInstance instance = TopDownExt.getTargetInstance(isSource, end, transitionedOperation, transfo_p);
            if (instance != null) {
                partBounds.add(instance);
                continue;
            }
            UnwantedObjects.add((EObject)end.getEvent(), transfo_p);
        }
        if (partBounds.size() == 0 && role.getRepresentedInstance() != null) {
            String messageTxxt = Messages.Scenario_MultipleTransitionedElements;
            List availables = Query.retrieveTransformedElements((EObject)role.getRepresentedInstance(), (ITransfo)transfo_p, (EClass)InformationPackage.Literals.ABSTRACT_INSTANCE);
            if (availables.size() == 0 && role.getRepresentedInstance() instanceof Part) {
                for (Component element : Query.retrieveTransformedElements((EObject)role.getRepresentedInstance().getAbstractType(), (ITransfo)transfo_p, (EClass)CsPackage.Literals.COMPONENT)) {
                    availables.addAll(element.getRepresentingParts());
                }
            }
            if (availables.size() <= 1) {
                partBounds.addAll(availables);
            } else {
                List res;
                ResolverFinalizer resolver = ResolverFinalizer.getResolver((ITransfo)transfo_p);
                if (resolver != null && (res = resolver.resolve((EObject)role.getRepresentedInstance(), availables, ScenarioTransfo.getTitle(transfo_p), messageTxxt, false, transfo_p, new EObject[]{role.getRepresentedInstance()})) != null && res.size() > 0) {
                    partBounds.add((AbstractInstance)res.get(0));
                }
            }
        }
        partBounds = ListExt.removeDuplicates(partBounds);
        return partBounds;
    }

    public static AbstractInstance getTargetInstance(boolean isSource, AbstractEnd sourceEnd, AbstractEventOperation targetOperation, ITransfo transfo_p) {
        Collection<AbstractInstance> relatedParts;
        List<AbstractInstance> partBounds = new ArrayList<AbstractInstance>();
        if (targetOperation == null) {
            return null;
        }
        if (ScenarioExt.isFunctionalInstanceRole(sourceEnd) || ScenarioExt.isRoleInstanceRole(sourceEnd)) {
            relatedParts = TopDownExt.getRelatedInstances(isSource, (EObject)targetOperation, transfo_p);
            partBounds.addAll(relatedParts);
        } else if (ScenarioExt.isPartInstanceRole(sourceEnd)) {
            relatedParts = TopDownExt.getRelatedInstances(isSource, (EObject)targetOperation, transfo_p);
            for (AbstractInstance relatedPart : relatedParts) {
                for (AbstractInstance parent : TopDownExt.getRelatedPartAndAncestors(relatedPart)) {
                    for (InstanceRole relatedRole : sourceEnd.getCoveredInstanceRoles()) {
                        if (!RefinementLinkExt.isLinkedTo((TraceableElement)parent, (TraceableElement)relatedRole.getRepresentedInstance())) continue;
                        partBounds.add(relatedPart);
                    }
                }
            }
            if (partBounds.isEmpty()) {
                partBounds.addAll(relatedParts);
            }
        } else if (ScenarioExt.isExchangeItemInstanceRole(sourceEnd)) {
            ExchangeItemInstance instance = ScenarioExt.getExchangeItemInstanceRole(sourceEnd);
            if (targetOperation instanceof ExchangeItemAllocation) {
                if (RefinementLinkExt.isLinkedTo((TraceableElement)((ExchangeItemAllocation)targetOperation).getAllocatedItem(), (TraceableElement)instance.getType())) {
                    List instances = Query.retrieveTransformedElements((EObject)instance, (ITransfo)transfo_p, (EClass)InformationPackage.Literals.ABSTRACT_INSTANCE);
                    partBounds.addAll(instances);
                } else if (((ExchangeItemAllocation)targetOperation).getAllocatedItem().equals(instance.getType())) {
                    partBounds.add((AbstractInstance)instance);
                }
            }
        }
        partBounds = ListExt.removeDuplicates(partBounds);
        if (partBounds.size() == 0) {
            return null;
        }
        if (partBounds.size() == 1) {
            return (AbstractInstance)partBounds.get(0);
        }
        ResolverFinalizer resolver = ResolverFinalizer.getResolver((ITransfo)transfo_p);
        if (resolver == null) {
            return (AbstractInstance)partBounds.get(0);
        }
        SequenceMessage message = ScenarioExt.getRelatedSequenceMessage(sourceEnd);
        String messageTxt = NLS.bind((String)(isSource ? Messages.Scenario_SourceMessage : Messages.Scenario_TargetMessage), (Object[])new Object[]{TopDownExt.getPosition(message), EObjectLabelProviderHelper.getText((Object)message), EObjectLabelProviderHelper.getText((Object)targetOperation), EObjectLabelProviderHelper.getMetaclassLabel((EObject)targetOperation, (boolean)true)});
        MessageEnd context = isSource ? message.getSendingEnd() : message.getReceivingEnd();
        return (AbstractInstance)resolver.resolve((EObject)targetOperation, partBounds, ScenarioTransfo.getTitle(transfo_p), messageTxt, false, transfo_p, new EObject[]{message, targetOperation, context}).get(0);
    }

    private static Collection<AbstractInstance> getRelatedPartAndAncestors(AbstractInstance relatedPart_p) {
        ArrayList<AbstractInstance> parents = new ArrayList<AbstractInstance>();
        parents.add(relatedPart_p);
        if (relatedPart_p instanceof Part) {
            parents.addAll(ComponentExt.getPartAncestors((Part)((Part)relatedPart_p), (boolean)true));
        }
        return parents;
    }

    private static String getPosition(SequenceMessage message_p) {
        EObject container = message_p.eContainer();
        EStructuralFeature reference = message_p.eContainingFeature();
        Object value = null;
        int position = 1;
        if (container != null && reference != null && reference.isMany() && (value = container.eGet(reference)) instanceof List) {
            position = ((List)value).indexOf(message_p) + 1;
        }
        switch (position % 10) {
            case 1: {
                return String.valueOf(position) + Messages.Scenario_First;
            }
            case 2: {
                return String.valueOf(position) + Messages.Scenario_Second;
            }
            case 3: {
                return String.valueOf(position) + Messages.Scenario_Third;
            }
        }
        return String.valueOf(position) + Messages.Scenario_Nth;
    }

    public static Collection<AbstractInstance> getRelatedInstances(boolean isSource, EObject operation, ITransfo transfo_p) {
        Interface itf;
        ComponentExchange exchange;
        Scenario scenario = (Scenario)transfo_p.get((Object)"transfoSource");
        boolean shouldRetrieveAllocating = !TransitionHelper.getService().isFunctionalScenario(scenario);
        LinkedHashSet componentBounds = new LinkedHashSet();
        LinkedHashSet<AbstractInstance> instances = new LinkedHashSet<AbstractInstance>();
        if (operation instanceof ComponentExchange) {
            exchange = (ComponentExchange)operation;
            if (isSource || !exchange.isOriented()) {
                instances.addAll(ComponentExchangeExt.getSourceParts((ComponentExchange)exchange));
            }
            if (!isSource || !exchange.isOriented()) {
                instances.addAll(ComponentExchangeExt.getTargetParts((ComponentExchange)exchange));
            }
        } else if (operation instanceof FunctionalExchange) {
            AbstractFunction function;
            exchange = (FunctionalExchange)operation;
            AbstractFunction abstractFunction = function = isSource ? FunctionalExchangeExt.getSourceFunction((FunctionalExchange)exchange) : FunctionalExchangeExt.getTargetFunction((FunctionalExchange)exchange);
            if (function != null) {
                if (shouldRetrieveAllocating) {
                    componentBounds.addAll(AbstractFunctionExt.getAllocatingComponents((AbstractFunction)function));
                    if (function instanceof OperationalActivity) {
                        for (Role role : ((OperationalActivity)function).getAllocatingRoles()) {
                            componentBounds.addAll(role.getAllocatingEntities());
                        }
                    }
                } else {
                    instances.add((AbstractInstance)function);
                }
            }
        } else if (operation instanceof ExchangeItemAllocation && (itf = ((ExchangeItemAllocation)operation).getAllocatingInterface()) != null) {
            if (isSource) {
                componentBounds.addAll(itf.getUserComponents());
                componentBounds.addAll(itf.getRequiringComponents());
            } else {
                componentBounds.addAll(itf.getImplementorComponents());
                componentBounds.addAll(itf.getProvidingComponents());
            }
        }
        for (Component component : componentBounds) {
            if (component == null) continue;
            instances.addAll((Collection<AbstractInstance>)component.getRepresentingParts());
        }
        EObject targetScenario = (EObject)Query.retrieveTransformedElements((EObject)scenario.eContainer(), (ITransfo)transfo_p).get(0);
        BlockArchitecture targetArchitecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)targetScenario);
        if (targetArchitecture instanceof EPBSArchitecture) {
            Iterator iterator = instances.iterator();
            while (iterator.hasNext()) {
                AbstractInstance instance = (AbstractInstance)iterator.next();
                iterator.remove();
                if (instance == null || !(instance.getAbstractType() instanceof PhysicalComponent)) continue;
                for (ConfigurationItem item : ((PhysicalComponent)instance.getAbstractType()).getAllocatorConfigurationItems()) {
                    instances.addAll((Collection<AbstractInstance>)item.getRepresentingParts());
                }
            }
        }
        instances.removeIf(x -> !targetArchitecture.eClass().isInstance((Object)BlockArchitectureExt.getRootBlockArchitecture((EObject)x)));
        instances.remove(null);
        return instances;
    }

    public static AbstractEventOperation getTransitionedOperation(EObject element_p, ITransfo transfo_p) {
        if (element_p instanceof ExecutionEnd) {
            return TopDownExt.getTransitionedOperation((EObject)((ExecutionEnd)element_p).getExecution().getStart(), transfo_p);
        }
        if (element_p instanceof AbstractEnd) {
            return TopDownExt.getTransitionedOperation((EObject)((AbstractEnd)element_p).getEvent(), transfo_p);
        }
        if (element_p instanceof Event) {
            SequenceMessage message = ScenarioExt.getRelatedSequenceMessage((Event)element_p);
            AbstractEventOperation operation = ScenarioExt.getOperation(element_p);
            String messageTxxt = Messages.Scenario_MultipleTransitionedElements;
            List availables = Query.retrieveTransformedElements((EObject)operation, (ITransfo)transfo_p, (EClass)InformationPackage.Literals.ABSTRACT_EVENT_OPERATION);
            if (availables.size() == 0) {
                if (operation instanceof ExchangeItemAllocation) {
                    return operation;
                }
                return null;
            }
            if (availables.size() == 1) {
                return (AbstractEventOperation)availables.get(0);
            }
            ResolverFinalizer resolver = ResolverFinalizer.getResolver((ITransfo)transfo_p);
            if (resolver == null) {
                return (AbstractEventOperation)availables.get(0);
            }
            List res = resolver.resolve((EObject)operation, availables, ScenarioTransfo.getTitle(transfo_p), messageTxxt, false, transfo_p, new EObject[]{operation, message});
            if (res != null && res.size() > 0) {
                return (AbstractEventOperation)res.get(0);
            }
        }
        return null;
    }
}

