/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.scenario.es2is.rules;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.ScenarioKind;
import org.polarsys.capella.core.projection.common.context.IContext;
import org.polarsys.capella.core.projection.interfaces.generateInterfaces.GenerateInterfacesCommand;
import org.polarsys.capella.core.projection.scenario.Messages;
import org.polarsys.capella.core.projection.scenario.common.rules.Rule_CapellaElement;
import org.polarsys.capella.core.tiger.ITransfo;
import org.polarsys.capella.core.tiger.helpers.Query;

public class Rule_Scenario
extends Rule_CapellaElement {
    public Rule_Scenario() {
        super(InteractionPackage.Literals.SCENARIO, InteractionPackage.Literals.SCENARIO, InteractionPackage.Literals.SCENARIO_REALIZATION);
    }

    protected EStructuralFeature getTargetContainementFeature(EObject element_p, EObject result_p, EObject container_p, IContext context_p) {
        return InteractionPackage.Literals.ABSTRACT_CAPABILITY__OWNED_SCENARIOS;
    }

    protected EObject getBestContainer(EObject element_p, EObject result_p, IContext context_p) {
        return element_p.eContainer();
    }

    protected EObject transformDirectElement(EObject element_p, IContext context_p) {
        EObject result = super.transformDirectElement(element_p, context_p);
        if (result instanceof AbstractNamedElement && element_p instanceof AbstractNamedElement) {
            ((AbstractNamedElement)result).setName(String.valueOf(((AbstractNamedElement)element_p).getName()) + Messages.ScenarioSuffix_IS);
        }
        context_p.put("transfoTarget", (Object)result);
        return result;
    }

    public void update_(EObject element_p, ITransfo transfo_p) {
        super.update_(element_p, transfo_p);
        Scenario source = (Scenario)element_p;
        for (Scenario target : Query.retrieveUnattachedTransformedElements((EObject)source, (ITransfo)transfo_p, (EClass)this.getTargetType())) {
            target.setKind(ScenarioKind.INTERFACE);
        }
    }

    protected void runSubTransitionBeforeTransform(EObject element_p, ITransfo transfo_p) {
        super.runSubTransitionBeforeTransform(element_p, transfo_p);
        Scenario scenario = (Scenario)element_p;
        for (InstanceRole role : scenario.getOwnedInstanceRoles()) {
            AbstractInstance instance = role.getRepresentedInstance();
            if (instance == null || !(instance.getAbstractType() instanceof Component)) continue;
            Component type = (Component)instance.getAbstractType();
            GenerateInterfacesCommand command = new GenerateInterfacesCommand(Arrays.asList(type), (IProgressMonitor)new NullProgressMonitor());
            command.run();
        }
    }

    @Override
    protected void retrieveGoDeep(EObject source_p, List<EObject> result_p, IContext context_p) {
        super.retrieveGoDeep(source_p, result_p, context_p);
        Scenario s = (Scenario)source_p;
        result_p.addAll((Collection<EObject>)s.getOwnedInteractionFragments());
        result_p.addAll((Collection<EObject>)s.getOwnedMessages());
        result_p.addAll((Collection<EObject>)s.getOwnedTimeLapses());
        result_p.addAll((Collection<EObject>)s.getOwnedEvents());
        result_p.addAll((Collection<EObject>)s.getOwnedInstanceRoles());
    }

    protected void retrieveContainer(EObject element_p, List<EObject> result_p, IContext context_p) {
    }
}

