/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.project;

import org.apache.log4j.Logger;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.platform.sirius.ui.project.Messages;

public class NewModelWizardPage
extends WizardPage {
    private static final Logger __logger = ReportManagerRegistry.getInstance().subscribe("User Interface");
    private static final int SIZING_TEXT_FIELD_WIDTH = 150;
    private Text _modelNameField;
    private String _modelName;
    private boolean _opaSelected;
    private boolean _epbsSelected;
    private ModifyListener _nameModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent event_p) {
            boolean valid = NewModelWizardPage.this.validatePage();
            NewModelWizardPage.this.setPageComplete(valid);
        }
    };

    public NewModelWizardPage(String pageName_p) {
        super(pageName_p);
        this.setPageComplete(false);
        this._opaSelected = true;
        this._epbsSelected = true;
    }

    public void dispose() {
        if (!this._modelNameField.isDisposed()) {
            this._modelNameField.removeModifyListener(this._nameModifyListener);
        }
        super.dispose();
    }

    public void createControl(Composite parent_p) {
        this.initializeDialogUnits((Control)parent_p);
        Composite composite = new Composite(parent_p, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData gData = new GridData();
        gData.horizontalAlignment = 4;
        gData.verticalAlignment = 4;
        composite.setLayoutData((Object)gData);
        Label modelLabel = new Label(composite, 0);
        modelLabel.setText(Messages.getString("NewModelWizardPage.model.name"));
        modelLabel.setFont(parent_p.getFont());
        this._modelNameField = new Text(composite, 2048);
        gData = new GridData();
        gData.horizontalAlignment = 4;
        gData.grabExcessHorizontalSpace = true;
        gData.minimumWidth = 150;
        gData.minimumWidth = 150;
        this._modelNameField.setLayoutData((Object)gData);
        this._modelNameField.setFont(parent_p.getFont());
        this._modelNameField.addModifyListener(this._nameModifyListener);
        Label architectureOptionsLabel = new Label(composite, 0);
        architectureOptionsLabel.setText(Messages.getString("NewModelWizardPage.architectures.options.label"));
        Composite container = new Composite(composite, 2048);
        GridData containerData = new GridData();
        containerData.horizontalAlignment = 4;
        containerData.grabExcessHorizontalSpace = true;
        containerData.verticalAlignment = 4;
        containerData.grabExcessVerticalSpace = true;
        container.setLayoutData((Object)containerData);
        GridLayout buttonsLayout = new GridLayout(1, true);
        container.setLayout((Layout)buttonsLayout);
        Button opaCheckBox = this.createCheckBox(container, Messages.getString("NewModelWizardPage.operationalAnalysis.name"), true, this._opaSelected);
        opaCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                NewModelWizardPage.this.doOpaSelected(event_p);
            }
        });
        this.createCheckBox(container, Messages.getString("NewModelWizardPage.contextArchitecture.name"), false, true);
        this.createCheckBox(container, Messages.getString("NewModelWizardPage.logicalArchitecture.name"), false, true);
        this.createCheckBox(container, Messages.getString("NewModelWizardPage.physicalArchitecture.name"), false, true);
        Button epbsCheckBox = this.createCheckBox(container, Messages.getString("NewModelWizardPage.epbsArchitecture.name"), true, this._epbsSelected);
        epbsCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                NewModelWizardPage.this.doEpbsSelected(event_p);
            }
        });
        this.setPageComplete(this.validatePage());
        this.setControl((Control)composite);
    }

    protected Button createCheckBox(Composite parent_p, String label_p, boolean enabled_p, boolean defaultSelection_p) {
        Button checkBox = new Button(parent_p, 32);
        checkBox.setText(label_p);
        GridData ctxGridData = new GridData();
        ctxGridData.horizontalAlignment = 4;
        checkBox.setLayoutData((Object)ctxGridData);
        checkBox.setSelection(defaultSelection_p);
        checkBox.setEnabled(enabled_p);
        return checkBox;
    }

    protected void doEpbsSelected(SelectionEvent event_p) {
        this._epbsSelected = ((Button)event_p.widget).getSelection();
    }

    protected boolean validatePage() {
        this._modelName = null;
        if ("".equals(this._modelNameField.getText().trim())) {
            this.setErrorMessage("Model name must be specified");
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        this._modelName = this._modelNameField.getText().trim();
        return true;
    }

    public void setVisible(boolean visible_p) {
        super.setVisible(visible_p);
        if (visible_p) {
            this._modelNameField.setFocus();
        }
    }

    public String getModelName() {
        return this._modelName;
    }

    public boolean isOpaSelected() {
        return this._opaSelected;
    }

    public boolean isEpbsSelected() {
        return this._epbsSelected;
    }

    public void setModelNameFieldValue(String value_p) {
        this._modelNameField.setText(value_p);
    }

    protected void doOpaSelected(SelectionEvent event_p) {
        this._opaSelected = ((Button)event_p.widget).getSelection();
    }
}

