/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.migration;

import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.polarsys.capella.core.data.migration.AbstractMigrationRunnable;
import org.polarsys.capella.core.data.migration.context.MigrationContext;

public class MigrationJob
extends WorkspaceJob {
    public static final QualifiedName RESULT_PROPERTY = new QualifiedName("org.polarsys.capella.core.data.migration", "result");
    private boolean checkVersion;
    private MigrationContext context;
    private AbstractMigrationRunnable runnable;

    public MigrationJob(AbstractMigrationRunnable runnable, MigrationContext context, boolean checkVersion) {
        super(context.getName());
        this.context = context;
        this.runnable = runnable;
        this.checkVersion = checkVersion;
        this.setRule((ISchedulingRule)runnable.getFile().getProject().getWorkspace().getRoot());
        this.setUser(true);
        this.setSystem(false);
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) {
        monitor.beginTask(this.getName(), 100);
        try {
            IStatus result = this.runnable.run(this.context, this.checkVersion);
            if (result.isOK()) {
                try {
                    this.runnable.getFile().getProject().refreshLocal(2, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)5));
                }
                catch (CoreException exception) {
                    result = new Status(4, "org.polarsys.capella.core.data.migration", exception.getMessage(), (Throwable)exception);
                }
            }
            this.setProperty(RESULT_PROPERTY, result);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            monitor.done();
            this.runnable = null;
            this.context = null;
        }
    }
}

