/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.policy;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.IdentityCommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractFrame;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.CombinedFragment;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Operand;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.operation.VerticalSpaceExpansionOrReduction;
import org.eclipse.sirius.diagram.sequence.ui.Messages;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.operation.SequenceEditPartsOperations;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.CombinedFragmentCompartmentEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.CombinedFragmentEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.ISequenceEventEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.OperandEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.policy.AbstractFrameResizableEditPolicy;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.policy.ISEComplexMoveCommandBuilder;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator.AbstractInteractionFrameValidator;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator.ISEComplexMoveValidator;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.util.RequestQuery;
import org.eclipse.sirius.diagram.sequence.util.Range;
import org.eclipse.sirius.diagram.ui.business.internal.operation.AbstractModelChangeOperation;
import org.eclipse.sirius.diagram.ui.tools.internal.edit.command.CommandFactory;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public class CombinedFragmentResizableEditPolicy
extends AbstractFrameResizableEditPolicy {
    protected Command getMoveCommand(ChangeBoundsRequest request) {
        this.cancelHorizontalDelta(request);
        CombinedFragmentEditPart hostPart = (CombinedFragmentEditPart)this.getHost();
        IdentityCommand solution = IdentityCommand.INSTANCE;
        RequestQuery requestQuery = new RequestQuery((Request)request);
        if (hostPart.getSelected() == 2 && requestQuery.isMove()) {
            ISEComplexMoveValidator validator = ISEComplexMoveValidator.getOrCreateValidator(request, requestQuery, hostPart.getISequenceEvent());
            if (validator != null && validator.isValid()) {
                CompositeTransactionalCommand ctc = this.buildNewMoveCommand(hostPart, request, validator);
                this.postProcessDefaultCommand(hostPart, request, ctc, null);
                solution = ctc;
            } else {
                solution = UnexecutableCommand.INSTANCE;
            }
        }
        return new ICommandProxy((ICommand)solution);
    }

    private CompositeTransactionalCommand buildNewMoveCommand(CombinedFragmentEditPart hostPart, ChangeBoundsRequest request, ISEComplexMoveValidator validator) {
        TransactionalEditingDomain editingDomain = hostPart.getEditingDomain();
        ISEComplexMoveCommandBuilder builder = new ISEComplexMoveCommandBuilder(editingDomain, Messages.CombinedFragmentResizableEditPolicy_moveCompositeCommand, new RequestQuery((Request)request), validator);
        return builder.buildCommand();
    }

    protected Command getResizeCommand(ChangeBoundsRequest request) {
        org.eclipse.gef.commands.UnexecutableCommand result;
        this.cancelHorizontalDelta(request);
        CombinedFragmentEditPart cfep = (CombinedFragmentEditPart)this.getHost();
        ISequenceEvent fragment = cfep.getISequenceEvent();
        AbstractInteractionFrameValidator validator = AbstractInteractionFrameValidator.getOrCreateResizeValidator(request, (AbstractFrame)((CombinedFragment)fragment));
        if (validator != null && validator.isValid()) {
            CompositeTransactionalCommand ctc = this.getRezizeCustomCommand(cfep, request);
            Range expansionZone = validator.getExpansionZone();
            ICommand autoExpand = null;
            if (expansionZone != null && !expansionZone.isEmpty()) {
                SequenceDiagram diagram = fragment.getDiagram();
                List<ISequenceEvent> eventToIgnore = Collections.singletonList(fragment);
                autoExpand = CommandFactory.createICommand((TransactionalEditingDomain)cfep.getEditingDomain(), (AbstractModelChangeOperation)new VerticalSpaceExpansionOrReduction(diagram, expansionZone, Integer.valueOf(0), eventToIgnore));
            }
            this.postProcessDefaultCommand(cfep, request, ctc, autoExpand);
            result = new ICommandProxy((ICommand)ctc);
        } else {
            result = org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
        }
        return result;
    }

    private CompositeTransactionalCommand getRezizeCustomCommand(CombinedFragmentEditPart self, ChangeBoundsRequest request) {
        CompositeTransactionalCommand ctc = new CompositeTransactionalCommand(self.getEditingDomain(), Messages.CombinedFragmentResizableEditPolicy_resizeCompositeCommand);
        ctc.add((IUndoableOperation)CombinedFragmentResizableEditPolicy.getResizeBorderItemTCommand((IGraphicalEditPart)self, request));
        Option combinedFragmentOption = ISequenceElementAccessor.getCombinedFragment((View)self.getNotationView());
        if (combinedFragmentOption.some() && !((CombinedFragment)combinedFragmentOption.get()).getOperands().isEmpty()) {
            if (request.getResizeDirection() == 1) {
                this.addResizeOperandsFromNorthCommand(ctc, request);
            } else if (request.getResizeDirection() == 4) {
                this.addResizeOperandsFromSouthCommand(ctc, request);
            }
        }
        return ctc;
    }

    private void postProcessDefaultCommand(CombinedFragmentEditPart self, ChangeBoundsRequest request, CompositeTransactionalCommand ctc, ICommand autoExpand) {
        if (ctc != null && ctc.canExecute()) {
            if (autoExpand != null) {
                ctc.compose((IUndoableOperation)autoExpand);
            }
            SequenceEditPartsOperations.addRefreshGraphicalOrderingCommand(ctc, (IGraphicalEditPart)self);
            SequenceEditPartsOperations.addRefreshSemanticOrderingCommand(ctc, (IGraphicalEditPart)self);
            SequenceEditPartsOperations.addSynchronizeSemanticOrderingCommand(ctc, self.getISequenceEvent());
        }
    }

    private void addResizeOperandsFromNorthCommand(CompositeTransactionalCommand ctc, ChangeBoundsRequest request) {
        Range verticalRange;
        OperandEditPart firstOperandEditPart = this.getFirstOperandEditPart();
        Option firstOperand = ISequenceElementAccessor.getOperand((View)firstOperandEditPart.getNotationView());
        int position = 0;
        OperandEditPart followingOperandEditPart = this.getFollowingOperandEditPart(position);
        Option followingOperand = followingOperandEditPart != null ? ISequenceElementAccessor.getOperand((View)followingOperandEditPart.getNotationView()) : Options.newNone();
        ++position;
        Point newLocation = null;
        Dimension newDimension = null;
        if (firstOperand.some()) {
            verticalRange = ((Operand)firstOperand.get()).getVerticalRange();
            newLocation = new Point(0, 30);
            newDimension = new Dimension(((Operand)firstOperand.get()).getBounds().width, verticalRange.width() + request.getSizeDelta().height);
            ctc.add((IUndoableOperation)this.createOperandSetBoundsCommand((IGraphicalEditPart)firstOperandEditPart, newLocation, newDimension));
        }
        if (followingOperandEditPart != null && followingOperand.some()) {
            while (followingOperandEditPart != null && followingOperand.some()) {
                verticalRange = ((Operand)followingOperand.get()).getVerticalRange();
                newLocation = new Point(0, newLocation.y + newDimension.height);
                newDimension = new Dimension(((Operand)followingOperand.get()).getBounds().width, verticalRange.width());
                ctc.add((IUndoableOperation)this.createOperandSetBoundsCommand((IGraphicalEditPart)followingOperandEditPart, newLocation, newDimension));
                followingOperandEditPart = this.getFollowingOperandEditPart(position);
                followingOperand = followingOperandEditPart != null ? ISequenceElementAccessor.getOperand((View)followingOperandEditPart.getNotationView()) : Options.newNone();
                ++position;
            }
        }
    }

    public void addResizeOperandsFromSouthCommand(CompositeTransactionalCommand ctc, ChangeBoundsRequest request) {
        Range verticalRange;
        OperandEditPart firstOperandEditPart = this.getFirstOperandEditPart();
        Option firstOperand = ISequenceElementAccessor.getOperand((View)firstOperandEditPart.getNotationView());
        int position = 0;
        OperandEditPart followingOperandEditPart = this.getFollowingOperandEditPart(position);
        Option followingOperand = followingOperandEditPart != null ? ISequenceElementAccessor.getOperand((View)followingOperandEditPart.getNotationView()) : Options.newNone();
        ++position;
        OperandEditPart lastOperandEditPart = this.getLastOperandEditPart();
        Point newLocation = null;
        Dimension newDimension = null;
        if (firstOperand.some()) {
            verticalRange = ((Operand)firstOperand.get()).getVerticalRange();
            newLocation = new Point(0, 30);
            newDimension = firstOperandEditPart == lastOperandEditPart ? new Dimension(((Operand)firstOperand.get()).getBounds().width, verticalRange.width() + request.getSizeDelta().height) : new Dimension(((Operand)firstOperand.get()).getBounds().width, verticalRange.width());
            ctc.add((IUndoableOperation)this.createOperandSetBoundsCommand((IGraphicalEditPart)firstOperandEditPart, newLocation, newDimension));
        }
        if (followingOperandEditPart != null && followingOperand.some()) {
            verticalRange = ((Operand)followingOperand.get()).getVerticalRange();
            while (followingOperandEditPart != null && followingOperand.some() && followingOperandEditPart != lastOperandEditPart) {
                newLocation = new Point(0, newLocation.y + newDimension.height);
                newDimension = new Dimension(((Operand)followingOperand.get()).getBounds().width, verticalRange.width());
                ctc.add((IUndoableOperation)this.createOperandSetBoundsCommand((IGraphicalEditPart)followingOperandEditPart, newLocation, newDimension));
                followingOperandEditPart = this.getFollowingOperandEditPart(position);
                followingOperand = followingOperandEditPart != null ? ISequenceElementAccessor.getOperand((View)followingOperandEditPart.getNotationView()) : Options.newNone();
                verticalRange = ((Operand)followingOperand.get()).getVerticalRange();
                ++position;
            }
            newLocation = new Point(0, newLocation.y + newDimension.height);
            newDimension = new Dimension(((Operand)followingOperand.get()).getBounds().width, verticalRange.width() + request.getSizeDelta().height);
            ctc.add((IUndoableOperation)this.createOperandSetBoundsCommand((IGraphicalEditPart)lastOperandEditPart, newLocation, newDimension));
        }
    }

    private OperandEditPart getFollowingOperandEditPart(int currentOperandIndex) {
        CombinedFragmentCompartmentEditPart combinedFragmentCompartmentEditPart = (CombinedFragmentCompartmentEditPart)((Object)Iterables.getOnlyElement((Iterable)Iterables.filter((Iterable)this.getHost().getChildren(), CombinedFragmentCompartmentEditPart.class)));
        Iterable operandEditPartList = Iterables.filter((Iterable)combinedFragmentCompartmentEditPart.getChildren(), OperandEditPart.class);
        for (OperandEditPart operandEditPart : operandEditPartList) {
            Operand operand;
            int operandIndex;
            Option operandOption = ISequenceElementAccessor.getOperand((View)operandEditPart.getNotationView());
            if (!operandOption.some() || (operandIndex = (operand = (Operand)operandOption.get()).getIndex()) != currentOperandIndex + 1) continue;
            return operandEditPart;
        }
        return null;
    }

    private OperandEditPart getFirstOperandEditPart() {
        CombinedFragmentCompartmentEditPart combinedFragmentCompartmentEditPart = (CombinedFragmentCompartmentEditPart)((Object)Iterables.getOnlyElement((Iterable)Iterables.filter((Iterable)this.getHost().getChildren(), CombinedFragmentCompartmentEditPart.class)));
        for (OperandEditPart operandEditPart : Iterables.filter((Iterable)combinedFragmentCompartmentEditPart.getChildren(), OperandEditPart.class)) {
            Operand operand;
            int operandIndex;
            Option operandOption = ISequenceElementAccessor.getOperand((View)operandEditPart.getNotationView());
            if (!operandOption.some() || (operandIndex = (operand = (Operand)operandOption.get()).getIndex()) != 0) continue;
            return operandEditPart;
        }
        return null;
    }

    private OperandEditPart getLastOperandEditPart() {
        CombinedFragmentCompartmentEditPart combinedFragmentCompartmentEditPart = (CombinedFragmentCompartmentEditPart)((Object)Iterables.getOnlyElement((Iterable)Iterables.filter((Iterable)this.getHost().getChildren(), CombinedFragmentCompartmentEditPart.class)));
        Iterable operandEditPartList = Iterables.filter((Iterable)combinedFragmentCompartmentEditPart.getChildren(), OperandEditPart.class);
        int childrenOperandEditPartNumber = Iterables.size((Iterable)operandEditPartList);
        for (OperandEditPart operandEditPart : operandEditPartList) {
            Operand operand;
            int operandIndex;
            Option operandOption = ISequenceElementAccessor.getOperand((View)operandEditPart.getNotationView());
            if (!operandOption.some() || (operandIndex = (operand = (Operand)operandOption.get()).getIndex()) != childrenOperandEditPartNumber - 1) continue;
            return operandEditPart;
        }
        return null;
    }

    public static AbstractTransactionalCommand getResizeBorderItemTCommand(IGraphicalEditPart part, ChangeBoundsRequest request) {
        EObject semantic = part.resolveSemanticElement();
        if (semantic instanceof DNodeContainer) {
            double zoom = ((ZoomManager)part.getViewer().getProperty(ZoomManager.class.toString())).getZoom();
            Dimension dimension = CombinedFragmentResizableEditPolicy.getDimensionFromView(part);
            Point position = CombinedFragmentResizableEditPolicy.getPositionFromView(part);
            dimension.height = (int)((double)dimension.height + (double)request.getSizeDelta().height / zoom);
            switch (request.getResizeDirection()) {
                case 1: 
                case 9: 
                case 17: {
                    position.y = (int)((double)position.y - (double)request.getSizeDelta().height / zoom);
                    break;
                }
            }
            return new SetBoundsCommand(part.getEditingDomain(), Messages.CombinedFragmentResizableEditPolicy_resizeSubCommand, (IAdaptable)new EObjectAdapter((EObject)part.getNotationView()), new Rectangle(position, dimension));
        }
        return null;
    }

    private AbstractTransactionalCommand createOperandSetBoundsCommand(IGraphicalEditPart part, Point location, Dimension dimension) {
        return new SetBoundsCommand(part.getEditingDomain(), Messages.CombinedFragmentResizableEditPolicy_resizeSubCommand, (IAdaptable)new EObjectAdapter((EObject)part.getNotationView()), new Rectangle(location, dimension));
    }

    private static Point getPositionFromView(IGraphicalEditPart part) {
        Point position = new Point();
        if (part.getNotationView() instanceof Node && ((Node)part.getNotationView()).getLayoutConstraint() instanceof Location) {
            Location location = (Location)((Node)part.getNotationView()).getLayoutConstraint();
            position.x = location.getX();
            position.y = location.getY();
        }
        return position;
    }

    private static Dimension getDimensionFromView(IGraphicalEditPart part) {
        Dimension dimension = new Dimension();
        if (part.getNotationView() instanceof Node && ((Node)part.getNotationView()).getLayoutConstraint() instanceof Size) {
            Size size = (Size)((Node)part.getNotationView()).getLayoutConstraint();
            dimension.width = size.getWidth();
            dimension.height = size.getHeight();
        }
        return dimension;
    }

    @Override
    protected Collection<ISequenceEventEditPart> getChildrenToFeedBack(ChangeBoundsRequest request) {
        ArrayList<ISequenceEventEditPart> feedback = new ArrayList<ISequenceEventEditPart>();
        if (this.getHost() instanceof CombinedFragmentEditPart && new RequestQuery((Request)request).isMove()) {
            CombinedFragmentEditPart cfep = (CombinedFragmentEditPart)this.getHost();
            for (CombinedFragmentCompartmentEditPart cpt : Iterables.filter((Iterable)cfep.getChildren(), CombinedFragmentCompartmentEditPart.class)) {
                Iterables.addAll(feedback, (Iterable)Iterables.filter((Iterable)cpt.getChildren(), OperandEditPart.class));
            }
        }
        return feedback;
    }
}

