/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.explorer.activity.ui.viewer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ui.tools.api.views.common.item.ItemWrapper;
import org.eclipse.sirius.ui.tools.api.views.common.item.RepresentationDescriptionItem;
import org.eclipse.sirius.ui.tools.api.views.common.item.ViewpointItem;
import org.eclipse.sirius.ui.tools.internal.views.common.item.ViewpointsFolderItemImpl;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.model.handler.provider.CapellaAdapterFactoryProvider;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;

public class CapellaArchitectureContentProvider
extends AdapterFactoryContentProvider {
    private static final Object[] NO_CHILD = new Object[0];
    private EClass _filteringMetaClassForCommonViewpoint;

    public CapellaArchitectureContentProvider(EClass filteringMetaClassForCommonViewpoint) {
        super(CapellaAdapterFactoryProvider.getInstance().getAdapterFactory());
        this._filteringMetaClassForCommonViewpoint = filteringMetaClassForCommonViewpoint;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof Session) {
            Session session = (Session)parentElement;
            return this.getSessionChildren(session);
        }
        if (parentElement instanceof ViewpointItem) {
            ViewpointItem viewpointItem = (ViewpointItem)parentElement;
            return this.handleViewPointItem(viewpointItem, viewpointItem.getChildren());
        }
        if (parentElement instanceof RepresentationDescriptionItem) {
            RepresentationDescriptionItem representationDescriptionItem = (RepresentationDescriptionItem)parentElement;
            return this.handleRepresentationDescriptionItem(representationDescriptionItem);
        }
        return NO_CHILD;
    }

    private Object[] handleRepresentationDescriptionItem(RepresentationDescriptionItem representationDescriptionItem) {
        Collection representationItems = representationDescriptionItem.getChildren();
        Iterator iterator = representationItems.iterator();
        while (iterator.hasNext()) {
            DRepresentationDescriptor representationDescriptor;
            BlockArchitecture rootBlockArchitecture;
            Object item = iterator.next();
            if (item instanceof ItemWrapper) {
                item = ((ItemWrapper)item).getWrappedObject();
            }
            if (!(item instanceof DRepresentationDescriptor) || (rootBlockArchitecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)(representationDescriptor = (DRepresentationDescriptor)item).getTarget())) != null && this._filteringMetaClassForCommonViewpoint.isSuperTypeOf(rootBlockArchitecture.eClass())) continue;
            iterator.remove();
        }
        if (!representationItems.isEmpty()) {
            return representationItems.toArray();
        }
        return NO_CHILD;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    private Object[] getSessionChildren(Session session) {
        ArrayList viewpointItems = new ArrayList();
        ViewpointsFolderItemImpl viewpointsFolderItem = new ViewpointsFolderItemImpl(session, (Object)session);
        for (Object viewpointItem : viewpointsFolderItem.getChildren()) {
            if (this.getChildren(viewpointItem).length <= 0) continue;
            viewpointItems.add(viewpointItem);
        }
        return viewpointItems.toArray();
    }

    private Object[] handleViewPointItem(ViewpointItem element, Collection<? extends Object> children) {
        ArrayList<Object> selectedChildren = new ArrayList<Object>(0);
        for (Object object : new ArrayList<Object>(children)) {
            ItemWrapper item = (ItemWrapper)object;
            Collection itemChildren = item.getChildren();
            if (itemChildren.isEmpty() || this.getChildren(object).length <= 0) continue;
            selectedChildren.add(object);
        }
        return selectedChildren.toArray();
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }
}

