/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.flexibility.wizards.renderer;

import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.polarsys.capella.common.flexibility.properties.schema.IProperty;
import org.polarsys.capella.common.flexibility.wizards.renderer.AbstractRenderer;
import org.polarsys.capella.common.flexibility.wizards.renderer.RestraintPropertyContentProvider;
import org.polarsys.capella.common.flexibility.wizards.schema.IRendererContext;

public class ComboRenderer
extends AbstractRenderer {
    private ComboViewer viewer;
    Label label;

    public Label createPartLabel(Composite parent, String text) {
        this.label = new Label(parent, 0);
        this.label.setText(text);
        return this.label;
    }

    @Override
    public void initialize(final IProperty property, final IRendererContext rendererContext) {
        this.viewer.setInput((Object)property);
        this.viewer.setSelection((ISelection)new StructuredSelection(rendererContext.getPropertyContext().getCurrentValue(property)));
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object value = ((IStructuredSelection)event.getSelection()).getFirstElement();
                ComboRenderer.this.updatedValue(property, rendererContext, value);
                ComboRenderer.this.changeValue(property, rendererContext, value);
            }
        });
    }

    @Override
    public void performRender(Composite parent, IRendererContext context) {
        if (this.isDescription() && !Boolean.FALSE.equals(context.getParameter("PARAMETER_RENDER_LABEL"))) {
            this.createPartLabel(parent, String.valueOf(context.getProperty(this).getName()) + ':');
        }
        this.viewer = new ComboViewer(parent);
        GridData data = new GridData(4, 4, true, false);
        this.viewer.getControl().setLayoutData((Object)data);
        this.viewer.setContentProvider((IContentProvider)new RestraintPropertyContentProvider(context.getPropertyContext()));
    }

    protected boolean isDescription() {
        return true;
    }

    @Override
    public void dispose(IRendererContext context) {
        this.viewer.getCombo().dispose();
        this.label.dispose();
        super.dispose(context);
    }
}

