/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.tools.report.config.persistence;

import java.util.ArrayList;
import java.util.List;
import org.polarsys.capella.common.tools.report.config.persistence.LogLevel;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class OutputConfiguration {
    protected List<LogLevel> logLevel;
    protected String outputName;

    public OutputConfiguration() {
    }

    public OutputConfiguration(OutputConfiguration source) {
        this.outputName = source.outputName;
        for (LogLevel level : this.getLogLevel()) {
            this.getLogLevel().add(new LogLevel(level));
        }
    }

    public OutputConfiguration(Element element) {
        this.setOutputName(element.getAttribute("outputName"));
        NodeList logLevelList = element.getElementsByTagName("LogLevel");
        this.logLevel = new ArrayList<LogLevel>();
        int i = 0;
        while (i < logLevelList.getLength()) {
            this.logLevel.add(new LogLevel((Element)logLevelList.item(i)));
            ++i;
        }
    }

    public List<LogLevel> getLogLevel() {
        if (this.logLevel == null) {
            this.logLevel = new ArrayList<LogLevel>(1);
        }
        return this.logLevel;
    }

    public String getOutputName() {
        return this.outputName;
    }

    public void setOutputName(String value) {
        this.outputName = value;
    }

    public Element convertToElement(Document document) {
        Element element = document.createElement("OutputConfiguration");
        Attr outputNameAttr = document.createAttribute("outputName");
        outputNameAttr.setValue(this.getOutputName());
        element.setAttributeNode(outputNameAttr);
        this.getLogLevel().forEach(level -> {
            Element logLevelElement = level.convertToElement(document);
            element.appendChild(logLevelElement);
        });
        return element;
    }
}

