/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.clipboard.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.core.diagram.helpers.TitleBlockHelper;
import org.polarsys.capella.core.platform.sirius.clipboard.util.LayerUtil;
import org.polarsys.capella.core.platform.sirius.clipboard.util.SiriusUtil;

public abstract class AbstractCopyPasteAction
implements IObjectActionDelegate {
    private static final Clipboard CLIPBOARD = new Clipboard(PlatformUI.getWorkbench().getDisplay());
    private IStructuredSelection _selection = null;
    private Shell _shell = null;
    private Text _editingTextWidget = null;
    private WrappingLabel _noteContent = null;

    protected void copyTextToSystemClipboard(String text) {
        if (text != null) {
            CLIPBOARD.setContents(new Object[]{text}, new Transfer[]{TextTransfer.getInstance()});
        }
    }

    private Control getChildUnderFocus(Composite composite) {
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (!child.isDisposed() && child.isFocusControl()) {
                return child;
            }
            ++n2;
        }
        return null;
    }

    protected List<? extends View> getCopyPasteSelection() {
        List<View> selectionList = LayerUtil.toGmf(this.getSelection());
        selectionList.removeIf(element -> TitleBlockHelper.isTitleBlockAnnotation((EObject)LayerUtil.getSiriusElement(element).getTarget()));
        return selectionList;
    }

    protected Text getEditingTextWidget() {
        return this._editingTextWidget;
    }

    protected WrappingLabel getSelectedNoteContentFigure() {
        return this._noteContent;
    }

    protected List<EditPart> getSelection() {
        return this.toGef(this._selection);
    }

    protected Shell getShell() {
        return this._shell;
    }

    protected String getTextFromSystemClipboard() {
        String result = null;
        Object contents = CLIPBOARD.getContents((Transfer)TextTransfer.getInstance());
        if (contents instanceof String) {
            result = (String)contents;
        }
        return result;
    }

    protected abstract boolean isEnabled();

    protected boolean isInLabelEdition() {
        return this._editingTextWidget != null;
    }

    protected boolean isInSequenceDiagram() {
        Object gmfElement;
        Object selected;
        boolean result = false;
        if (this._selection != null && !this._selection.isEmpty() && (selected = this._selection.getFirstElement()) instanceof EditPart && (gmfElement = ((EditPart)selected).getModel()) instanceof View) {
            EObject siriusElement = ((View)gmfElement).getElement();
            result = SiriusUtil.isInSequenceDiagram(siriusElement);
        }
        return result;
    }

    protected boolean isOnNoteContent() {
        return this._noteContent != null;
    }

    private Text lookupEditingTextWidget() {
        Composite selectedComposite;
        Control underFocus;
        EditPart selected;
        Text result = null;
        if (this._selection != null && this._selection.toList().size() == 1 && this._selection.getFirstElement() instanceof EditPart && (selected = (EditPart)this._selection.getFirstElement()).getViewer() != null && selected.getViewer().getControl() instanceof Composite && (underFocus = this.getChildUnderFocus(selectedComposite = (Composite)selected.getViewer().getControl())) instanceof Text) {
            result = (Text)underFocus;
        }
        return result;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this._selection = (IStructuredSelection)selection;
            this._editingTextWidget = this.lookupEditingTextWidget();
            this._noteContent = null;
            boolean enabled = this.isEnabled();
            if (action != null) {
                action.setEnabled(enabled);
            }
        } else {
            this._selection = null;
            this._editingTextWidget = null;
            this._noteContent = null;
            if (action != null) {
                action.setEnabled(false);
            }
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this._shell = targetPart.getSite().getShell();
    }

    private List<EditPart> toGef(IStructuredSelection selection) {
        ArrayList<EditPart> result = new ArrayList<EditPart>();
        if (selection != null) {
            for (Object current : selection) {
                if (!(current instanceof EditPart)) continue;
                result.add((EditPart)current);
            }
        }
        return result;
    }
}

