/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.toolkit.actions.move;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.ui.toolkit.AbstractCommandActionHandler;
import org.polarsys.capella.core.ui.toolkit.actions.move.Messages;

public abstract class AbstractMoveAction
extends AbstractCommandActionHandler {
    protected AbstractMoveAction(String text) {
        super(text);
    }

    @Override
    public boolean updateSelection(IStructuredSelection selection) {
        boolean result = true;
        if (!selection.isEmpty()) {
            Iterator iterator = selection.iterator();
            EObject parent = null;
            while (iterator.hasNext() && result) {
                Object selectedObject = iterator.next();
                if (!CapellaResourceHelper.isSemanticElement(selectedObject)) {
                    result = false;
                    continue;
                }
                EObject selectedElement = (EObject)selectedObject;
                if (parent != null && !selectedElement.eContainer().equals(parent)) {
                    result = false;
                    continue;
                }
                parent = selectedElement.eContainer();
                boolean bl = result = parent != null;
            }
        } else {
            result = false;
        }
        if (result) {
            result = super.updateSelection(selection);
        } else {
            this.setCommand(this.createUnexecutableCommand());
        }
        return result;
    }

    protected class CapellaMoveCommand
    extends CompoundCommand {
        private List<EObject> _collection;
        private boolean _isMovingUp;

        protected List<EObject> getSortedElementsToMove() {
            Collections.sort(this._collection, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    int result = 0;
                    if (o1 instanceof EObject && o2 instanceof EObject) {
                        int index2;
                        EReference containmentFeature;
                        EObject object1 = (EObject)o1;
                        EObject object2 = (EObject)o2;
                        EObject container = object1.eContainer();
                        List children = (List)container.eGet((EStructuralFeature)(containmentFeature = object1.eContainmentFeature()));
                        int index1 = children.indexOf(object1);
                        if (index1 > (index2 = children.indexOf(object2))) {
                            result = 1;
                        } else if (index2 > index1) {
                            result = -1;
                        }
                    }
                    return result;
                }
            });
            return this._collection;
        }

        public CapellaMoveCommand(String label, Collection<EObject> collection, boolean isMovingUp) {
            super(Integer.MAX_VALUE, label, Messages.AbstractMoveAction_MoveCommand_Description);
            this._collection = new ArrayList<EObject>(collection);
            this._isMovingUp = isMovingUp;
        }

        protected boolean prepare() {
            boolean result = true;
            Iterator<EObject> iterator = this._collection.iterator();
            while (iterator.hasNext() && result) {
                EObject object = iterator.next();
                EObject container = object.eContainer();
                EReference containmentFeature = object.eContainmentFeature();
                if (!containmentFeature.isMany()) {
                    result = false;
                    break;
                }
                List children = (List)container.eGet((EStructuralFeature)containmentFeature);
                int index = children.indexOf(object);
                if (index == 0 && this._isMovingUp) {
                    result = false;
                    break;
                }
                if (index != children.size() - 1 || this._isMovingUp) continue;
                result = false;
                break;
            }
            return result;
        }

        public void execute() {
            List<EObject> moveable = this.getSortedElementsToMove();
            TransactionalEditingDomain domain = TransactionHelper.getEditingDomain(moveable);
            Iterator<EObject> iterator = moveable.iterator();
            while (iterator.hasNext()) {
                EObject name;
                EObject object = name = iterator.next();
                EObject container = object.eContainer();
                EReference containmentFeature = object.eContainmentFeature();
                List children = (List)container.eGet((EStructuralFeature)containmentFeature);
                int index = children.indexOf(object);
                this.appendAndExecute(MoveCommand.create((EditingDomain)domain, (Object)container, (Object)containmentFeature, (Object)object, (int)(index += this._isMovingUp ? -1 : 1)));
            }
        }
    }
}

