/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.commands.preferences.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.progress.IProgressService;
import org.polarsys.capella.core.commands.preferences.ui.CapellaProjectPropertyContentProvider;
import org.polarsys.capella.core.commands.preferences.ui.ProjectSeltctionFilter;

public class ProjectReferencesPreferencePage
extends PropertyPage {
    IProject project;
    boolean modified = false;
    CheckboxTableViewer listViewer;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.initialize();
        this.createDescriptionLabel(composite);
        this.listViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2176);
        if (!this.project.isOpen()) {
            this.listViewer.getControl().setEnabled(false);
        }
        this.listViewer.setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        this.listViewer.setContentProvider((IContentProvider)this.getContentProvider(this.project));
        this.listViewer.setComparator(new ViewerComparator());
        this.listViewer.setInput((Object)this.project.getWorkspace());
        try {
            this.listViewer.setCheckedElements((Object[])this.project.getDescription().getReferencedProjects());
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.listViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    ProjectReferencesPreferencePage.this.listViewer.setCheckedElements(new Object[]{event.getElement()});
                }
                ProjectReferencesPreferencePage.this.modified = true;
            }
        });
        this.listViewer.addFilter((ViewerFilter)new ProjectSeltctionFilter());
        this.applyDialogFont(composite);
        GridLayoutFactory.fillDefaults().generateLayout(composite);
        return composite;
    }

    protected IStructuredContentProvider getContentProvider(final IProject prj) {
        return new CapellaProjectPropertyContentProvider(){

            public Object[] getChildren(Object o) {
                if (!(o instanceof IWorkspace)) {
                    return new Object[0];
                }
                IProject[] projects = ((IWorkspace)o).getRoot().getProjects();
                ArrayList<IProject> referenced = new ArrayList<IProject>(projects.length);
                boolean found = false;
                IProject[] iProjectArray = projects;
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project2 = iProjectArray[n2];
                    if (!found && project2.equals((Object)prj)) {
                        found = true;
                    } else {
                        referenced.add(project2);
                    }
                    ++n2;
                }
                try {
                    projects = prj.getDescription().getReferencedProjects();
                    int i = 0;
                    while (i < projects.length) {
                        if (!referenced.contains(projects[i])) {
                            referenced.add(projects[i]);
                        }
                        ++i;
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                return referenced.toArray();
            }
        };
    }

    protected void handle(InvocationTargetException e) {
        IStatus error;
        Throwable target = e.getTargetException();
        if (target instanceof CoreException) {
            error = ((CoreException)target).getStatus();
        } else {
            String msg = target.getMessage();
            if (msg == null) {
                msg = "Internal error";
            }
            error = new Status(4, "org.eclipse.ui.ide", 1, msg, target);
        }
        ErrorDialog.openError((Shell)this.getControl().getShell(), null, null, (IStatus)error);
    }

    private void initialize() {
        this.project = (IProject)this.getElement().getAdapter(IResource.class);
        this.noDefaultAndApplyButton();
        this.setDescription(NLS.bind((String)"Capella Projects may refer to other Capella Configuration projects in the workspace.\nUse this page to specify what other Capella Configuration Projects are referenced by the project.\n\n&Project references for ''{0}'':", (Object)this.project.getName()));
    }

    public boolean performOk() {
        if (!this.modified) {
            return true;
        }
        Object[] checked = this.listViewer.getCheckedElements();
        final IProject[] refs = new IProject[checked.length];
        System.arraycopy(checked, 0, refs, 0, checked.length);
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    IProjectDescription description = ProjectReferencesPreferencePage.this.project.getDescription();
                    description.setReferencedProjects(refs);
                    ProjectReferencesPreferencePage.this.project.setDescription(description, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        try {
            service.run(false, false, runnable);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            this.handle(e);
            return false;
        }
        return true;
    }
}

