/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.commands.preferences.ui;

import java.util.ArrayList;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.polarsys.capella.core.commands.preferences.internalization.l10n.PreferencesUIMessages;
import org.polarsys.capella.core.commands.preferences.model.IItemNode;

public class PreferencesFilter
extends ViewerFilter {
    private String searchValue;

    public void setSearchValue(String searchValue) {
        if (!searchValue.isEmpty() && !PreferencesUIMessages.CommandSelectionContainer_Filtering.equals(searchValue)) {
            if (searchValue.contains("*")) {
                searchValue = searchValue.replaceAll("\\*", "");
            }
            this.searchValue = ".*" + searchValue + ".*";
        } else {
            this.searchValue = null;
        }
    }

    public boolean select(Viewer viewer_p, Object parentElement, Object element) {
        if (this.searchValue == null || this.searchValue.isEmpty()) {
            return true;
        }
        if (element != null && element instanceof IItemNode) {
            IItemNode item = (IItemNode)element;
            return item.getName().matches(this.searchValue);
        }
        return false;
    }

    public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
        int size = elements.length;
        ArrayList<Object> out = new ArrayList<Object>(size);
        int i = 0;
        while (i < size) {
            Object element = elements[i];
            if (this.select(viewer, parent, element)) {
                out.add(element);
            }
            ++i;
        }
        return out.toArray();
    }
}

