/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.commands.preferences.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.polarsys.capella.core.commands.preferences.model.CategoryPreferences;
import org.polarsys.capella.core.commands.preferences.model.ICategoryTreeNode;
import org.polarsys.capella.core.commands.preferences.model.IItemNode;
import org.polarsys.capella.core.commands.preferences.preferences.ConfigurabilityPreferences;
import org.polarsys.capella.core.commands.preferences.service.IItemDescriptor;

public class ItemNode
implements IItemNode {
    private static final Map<String, IItemNode> instanceMap = new HashMap<String, IItemNode>();
    private final IItemDescriptor itemDescriptor;
    private boolean checked;
    private final Set<ICategoryTreeNode> categories = new HashSet<ICategoryTreeNode>();

    private ItemNode(IItemDescriptor constraint) {
        this.itemDescriptor = constraint;
        this.checked = constraint.isEnabled();
    }

    static IItemNode getInstance(IItemDescriptor constraint) {
        String id = constraint.getId();
        IItemNode result = null;
        if (id != null && (result = instanceMap.get(id)) == null) {
            result = new ItemNode(constraint);
            instanceMap.put(id, result);
        }
        return result;
    }

    public static void flushCache() {
        instanceMap.clear();
    }

    @Override
    public String getId() {
        return this.itemDescriptor.getId();
    }

    @Override
    public String getName() {
        return this.itemDescriptor.getName();
    }

    @Override
    public String getDescription() {
        return this.itemDescriptor.getDescription() != null ? this.itemDescriptor.getDescription() : "";
    }

    @Override
    public Collection<CategoryPreferences> getCategories() {
        return this.itemDescriptor.getCategories();
    }

    @Override
    public boolean isChecked() {
        return this.checked;
    }

    @Override
    public void setChecked(boolean checked) {
        if (checked != this.isChecked()) {
            this.checked = this.isMandatory() ? true : checked;
            this.updateCategories();
        }
        this.checked = checked;
    }

    @Override
    public boolean isMandatory() {
        return false;
    }

    @Override
    public void addCategory(ICategoryTreeNode category) {
        this.categories.add(category);
    }

    @Override
    public void checkStateChanged(CheckStateChangedEvent event) {
        if (event.getChecked() != this.isChecked()) {
            if (this.isMandatory() && !event.getChecked()) {
                event.getCheckable().setChecked((Object)this, true);
            } else {
                this.checked = event.getChecked();
            }
            this.updateCategories();
        }
    }

    @Override
    public void applyToPreferences() {
        ConfigurabilityPreferences.setItemEnabled(this.itemDescriptor.getId(), this.isChecked());
        this.itemDescriptor.setEnabled(!this.isChecked());
    }

    @Override
    public void revertFromPreferences() {
        this.setChecked(ConfigurabilityPreferences.isInstanceScopePreferenceItemEnabled(this.itemDescriptor.getId()));
    }

    @Override
    public void restoreDefaults() {
        this.setChecked(ConfigurabilityPreferences.isItemDisabledByDefault(this.itemDescriptor.getId()));
    }

    private void updateCategories() {
        for (ICategoryTreeNode next : this.categories) {
            next.updateCheckState(this);
        }
    }
}

