/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.commandline.core;

import org.eclipse.equinox.app.IApplicationContext;
import org.polarsys.capella.common.application.ArgumentsHelper;
import org.polarsys.capella.common.application.CommonArgumentsConstants;

public class CommandLineArgumentHelper {
    private static CommandLineArgumentHelper instance;
    private String input;
    private String outputFolder;
    private boolean helpNeeded;
    private String logFilePath;
    private String appid;
    private String importProjects;
    private String exportZips;
    private boolean forceImport;
    private boolean copyOnWorkspace = false;
    private boolean backup;
    @Deprecated
    private String filePath;
    @Deprecated
    private boolean createFolder;
    @Deprecated
    private String exportProject;
    @Deprecated
    private String zipNameProject;
    protected static String[] args;

    public static CommandLineArgumentHelper getInstance() {
        if (instance == null) {
            instance = new CommandLineArgumentHelper();
        }
        return instance;
    }

    public static String[] parseContext(IApplicationContext context) {
        args = (String[])context.getArguments().get("application.args");
        return args;
    }

    public void parseArgs(String[] args) {
        ArgumentsHelper helper = ArgumentsHelper.getInstance();
        helper.loadArguments(args);
        this.helpNeeded = helper.hasParameter("-help");
        this.createFolder = helper.hasParameter("-forceoutputfoldercreation");
        this.copyOnWorkspace = helper.hasParameter("-copyOnWorkspace");
        this.appid = helper.getString("-appid");
        this.importProjects = helper.getString("-import");
        this.exportZips = helper.getString("-exportZip");
        this.forceImport = helper.hasParameter("-forceimport");
        this.exportProject = helper.getString("-export");
        this.zipNameProject = helper.getString("-exportZipName");
        this.filePath = helper.getString("-filepath");
        this.input = helper.getString("-input");
        this.outputFolder = helper.getString("-outputfolder");
        this.logFilePath = helper.getString(CommonArgumentsConstants.LOG_FILE_PATH);
        this.backup = helper.hasParameter("-backup");
    }

    public static String[] getArgs() {
        return args;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getOutputFolder() {
        return this.outputFolder;
    }

    public boolean isHelpNeeded() {
        return this.helpNeeded;
    }

    public String getAppid() {
        return this.appid;
    }

    public String getImportProjects() {
        return this.importProjects;
    }

    public String getExportZips() {
        return this.exportZips;
    }

    public boolean isForceImport() {
        return this.forceImport;
    }

    public boolean isCreateFolder() {
        return this.createFolder;
    }

    public String getLogFilePath() {
        return this.logFilePath;
    }

    public boolean isCopyOnWorkspace() {
        return this.copyOnWorkspace;
    }

    public String getExportProject() {
        return this.exportProject;
    }

    public String getZipNameProject() {
        return this.zipNameProject;
    }

    public String getInputs() {
        return this.input;
    }

    public boolean isBackupNeeded() {
        return this.backup;
    }
}

