/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.browser.category;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.ui.toolkit.browser.category.ICategory;
import org.polarsys.capella.common.ui.toolkit.browser.internal.TypeHelper;
import org.polarsys.capella.common.ui.toolkit.browser.query.QueryAdapter;

public class CategoryImpl
implements ICategory {
    protected String id;
    protected String name;
    protected String typeQualifiedName;
    protected List<String> subCategoriesIds = new ArrayList<String>();
    protected Object categoryQuery;
    protected HashSet<Object> itemQueriesHashSet;
    protected List<Object> itemQueries = new ArrayList<Object>();
    protected boolean isTopLevel;
    protected boolean isUsedInShowRelated;

    @Override
    public boolean isAvailableForType(Object toTestTypeQualifiedName) {
        return TypeHelper.getInstance().isInstanceOf(toTestTypeQualifiedName, this.typeQualifiedName);
    }

    @Override
    public void setId(String pId) {
        this.id = pId;
    }

    @Override
    public void addSubCategoryId(String pId) {
        if (pId != null && !pId.isEmpty()) {
            this.subCategoriesIds.add(pId);
        }
    }

    @Override
    public void setQuery(Object query) {
        this.categoryQuery = query;
    }

    @Override
    public void setTypeFullyQualifiedName(String typeQualifiedName) {
        this.typeQualifiedName = typeQualifiedName;
    }

    @Override
    public List<String> getSubCategoryIds() {
        return this.subCategoriesIds;
    }

    @Override
    public List<Object> compute(Object currentElement) {
        return QueryAdapter.getInstance().compute(currentElement, this.categoryQuery);
    }

    @Override
    public void setName(String pName) {
        this.name = pName;
    }

    @Override
    public void setIsTopLevel(boolean isTopLevel) {
        this.isTopLevel |= isTopLevel;
    }

    @Override
    public boolean isTopLevel() {
        return this.isTopLevel;
    }

    @Override
    public void setIsUsedInShowRelated(boolean usedInShowRelated) {
        this.isUsedInShowRelated = usedInShowRelated;
    }

    @Override
    public boolean isUsedInShowRelated() {
        return this.isUsedInShowRelated;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Object> getItemQueries() {
        return this.itemQueries;
    }

    @Override
    public void addItemQuery(Object query) {
        if (query != null) {
            this.itemQueries.add(query);
        }
    }

    @Override
    public String getCategoryId() {
        return this.id;
    }

    @Override
    public String getTypeFullyQualifiedName() {
        return this.typeQualifiedName;
    }

    @Override
    public boolean overrides(ICategory otherCategory, EObject current) {
        return this.getName().equals(otherCategory.getName()) && TypeHelper.getInstance().isSubtype(this.typeQualifiedName, otherCategory.getTypeFullyQualifiedName(), current);
    }

    @Override
    public String getSymbolicName() {
        return StringUtils.uncapitalize((String)WordUtils.capitalizeFully((String)this.name.toLowerCase()).replaceAll("\\s+", ""));
    }
}

