/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.validation;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.eclipse.emf.validation.service.IBatchValidator;
import org.eclipse.emf.validation.service.ModelValidationService;

public class EValidatorAdapter
extends EObjectValidator {
    private IBatchValidator _validator = (IBatchValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH);

    public EValidatorAdapter() {
        this(true, false);
    }

    protected IBatchValidator getValidator() {
        return this._validator;
    }

    public EValidatorAdapter(boolean includeLiveConstraints_p, boolean reportSuccesses_p) {
        this._validator.setIncludeLiveConstraints(includeLiveConstraints_p);
        this._validator.setReportSuccesses(reportSuccesses_p);
    }

    public boolean validate(EObject eObject_p, DiagnosticChain diagnostics_p, Map<Object, Object> context_p) {
        return this.validate(eObject_p.eClass(), eObject_p, diagnostics_p, context_p);
    }

    public boolean validate(EClass eClass_p, EObject eObject_p, DiagnosticChain diagnostics_p, Map<Object, Object> context_p) {
        super.validate(eClass_p, eObject_p, diagnostics_p, context_p);
        IStatus status = Status.OK_STATUS;
        if (diagnostics_p != null && !this.hasProcessed(eObject_p, context_p)) {
            status = this.getValidator().validate(eObject_p, (IProgressMonitor)new NullProgressMonitor());
            this.processed(eObject_p, context_p, status);
            this.appendDiagnostics(status, diagnostics_p);
        }
        return status.isOK();
    }

    public boolean validate(EDataType eDataType_p, Object value_p, DiagnosticChain diagnostics_p, Map<Object, Object> context_p) {
        return super.validate(eDataType_p, value_p, diagnostics_p, context_p);
    }

    protected void processed(EObject eObject_p, Map<Object, Object> context_p, IStatus status_p) {
        if (context_p != null) {
            context_p.put(eObject_p, status_p);
        }
    }

    protected boolean hasProcessed(EObject eObject_p, Map<Object, Object> context_p) {
        boolean result = false;
        if (context_p != null) {
            EObject eObject = eObject_p;
            while (eObject != null && !result) {
                if (context_p.containsKey(eObject)) {
                    result = true;
                    continue;
                }
                eObject = eObject.eContainer();
            }
        }
        return result;
    }

    protected void appendDiagnostics(IStatus status_p, DiagnosticChain diagnostics_p) {
        if (status_p.isMultiStatus()) {
            IStatus[] children = status_p.getChildren();
            int i = 0;
            while (i < children.length) {
                this.appendDiagnostics(children[i], diagnostics_p);
                ++i;
            }
        } else if (status_p instanceof IConstraintStatus) {
            diagnostics_p.add((Diagnostic)new BasicDiagnostic(status_p.getSeverity(), status_p.getPlugin(), status_p.getCode(), status_p.getMessage(), ((IConstraintStatus)status_p).getResultLocus().toArray()));
        }
    }
}

