/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.signature;

import java.math.BigInteger;
import java.security.PublicKey;
import java.security.interfaces.RSAKey;
import java.util.AbstractMap;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.signature.AbstractSignature;
import org.apache.sshd.common.util.ValidateUtils;

public abstract class SignatureRSA
extends AbstractSignature {
    private int verifierSignatureSize = -1;

    protected SignatureRSA(String algorithm) {
        super(algorithm);
    }

    protected int getVerifierSignatureSize() {
        return this.verifierSignatureSize;
    }

    @Override
    public void initVerifier(SessionContext session, PublicKey key) throws Exception {
        super.initVerifier(session, key);
        RSAKey rsaKey = ValidateUtils.checkInstanceOf(key, RSAKey.class, "Not an RSA key");
        this.verifierSignatureSize = SignatureRSA.getVerifierSignatureSize(rsaKey);
    }

    public static int getVerifierSignatureSize(RSAKey key) {
        BigInteger modulus = key.getModulus();
        return (modulus.bitLength() + 8 - 1) / 8;
    }

    @Override
    public boolean verify(SessionContext session, byte[] sig) throws Exception {
        int expectedSize;
        byte[] data = sig;
        AbstractMap.SimpleImmutableEntry<String, byte[]> encoding = this.extractEncodedSignature(data);
        if (encoding != null) {
            String keyType = (String)encoding.getKey();
            String canonicalName = KeyUtils.getCanonicalKeyType(keyType);
            ValidateUtils.checkTrue("ssh-rsa".equals(canonicalName), "Mismatched key type: %s", (Object)keyType);
            data = (byte[])encoding.getValue();
        }
        ValidateUtils.checkTrue((expectedSize = this.getVerifierSignatureSize()) > 0, "Signature verification size has not been initialized");
        if (data.length < expectedSize) {
            byte[] pad = new byte[expectedSize];
            System.arraycopy(data, 0, pad, pad.length - data.length, data.length);
            data = pad;
        }
        return this.doVerify(data);
    }
}

