/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.information.validation.exchangeitem;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.ExchangeItemElement;
import org.polarsys.capella.core.data.information.ExchangeMechanism;
import org.polarsys.capella.core.data.information.ParameterDirection;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class CheckExchangeItemElementDirection
extends AbstractValidationRule {
    private ArrayList<IStatus> statuses;

    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof ExchangeItemElement) {
            this.statuses = new ArrayList();
            ExchangeItemElement exchangeItemElement = (ExchangeItemElement)eObj;
            ExchangeItem exchangeItemParent = (ExchangeItem)exchangeItemElement.eContainer();
            ExchangeMechanism exchangeMechanism = exchangeItemParent.getExchangeMechanism();
            if (exchangeMechanism != null && exchangeMechanism != ExchangeMechanism.OPERATION) {
                this.validateOtherExchangeMechanism(ctx, exchangeItemParent, exchangeItemElement, exchangeMechanism);
            } else {
                this.validateOperationExchangeMechanism(ctx, exchangeItemParent, exchangeItemElement, exchangeMechanism);
            }
            if (this.statuses.size() > 0) {
                return ConstraintStatus.createMultiStatus((IValidationContext)ctx, this.statuses);
            }
        }
        return ctx.createSuccessStatus();
    }

    private void validateOtherExchangeMechanism(IValidationContext ctx, ExchangeItem exchangeItemParent, ExchangeItemElement exchangeItemElement, ExchangeMechanism exchangeMechanism) {
        ParameterDirection direction = exchangeItemElement.getDirection();
        if (!direction.equals((Object)ParameterDirection.UNSET)) {
            String EIE_PARAMETER = "\"" + exchangeItemElement.getName() + "\" ( " + exchangeItemElement.eClass().getName() + " ) ";
            String EI_PARAMETER = "\"" + exchangeItemParent.getName() + "\" ( " + exchangeItemParent.eClass().getName() + " ) ";
            IStatus status = ctx.createFailureStatus(new Object[]{EIE_PARAMETER, EI_PARAMETER, exchangeMechanism.getName(), " shall not "});
            this.statuses.add(status);
        }
    }

    private void validateOperationExchangeMechanism(IValidationContext ctx, ExchangeItem exchangeItemParent, ExchangeItemElement exchangeItemElement, ExchangeMechanism exchangeMechanism) {
        ParameterDirection direction = exchangeItemElement.getDirection();
        if (direction == null || direction.equals((Object)ParameterDirection.UNSET)) {
            String EIE_PARAMETER = "\"" + exchangeItemElement.getName() + "\" ( " + exchangeItemElement.eClass().getName() + " ) ";
            String EI_PARAMETER = "\"" + exchangeItemParent.getName() + "\" ( " + exchangeItemParent.eClass().getName() + " ) ";
            IStatus status = ctx.createFailureStatus(new Object[]{EIE_PARAMETER, EI_PARAMETER, exchangeMechanism.getName(), " shall "});
            this.statuses.add(status);
        }
    }
}

