/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.capellamodeller.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.polarsys.capella.core.data.capellacore.AbstractDependenciesPkg;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.model.helpers.AbstractDependenciesPkgExt;
import org.polarsys.capella.core.model.helpers.DataPkgExt;
import org.polarsys.capella.core.model.helpers.InterfacePkgExt;
import org.polarsys.capella.core.model.helpers.intermodelInconsistencyDetection.TarjanAlgorithm;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public abstract class AbstractPkgDependenciesCycleValidationRule
extends AbstractValidationRule {
    private int identifierCounter = 0;
    private Map<Integer, AbstractDependenciesPkg> ident2Object = new HashMap<Integer, AbstractDependenciesPkg>();
    private Map<AbstractDependenciesPkg, Integer> object2Ident = new HashMap<AbstractDependenciesPkg, Integer>();

    protected abstract boolean shouldValidate(IValidationContext var1);

    public IStatus validate(IValidationContext ctx) {
        if (this.shouldValidate(ctx)) {
            IStatus status = this.doValidate(ctx);
            this.clearMaps();
            return status;
        }
        return ctx.createSuccessStatus();
    }

    protected EObject getTarget(IValidationContext ctx) {
        return ctx.getTarget();
    }

    protected IStatus doValidate(IValidationContext ctx) {
        Collection<AbstractDependenciesPkg> allPackages = this.getAllPackages(this.getTarget(ctx));
        this.skipCurrentConstraintFor(ctx, allPackages);
        List<List<AbstractDependenciesPkg>> cycles = this.getInterPackageCycles(allPackages);
        if (!cycles.isEmpty()) {
            return this.createCycleFailureStatus(ctx, cycles);
        }
        return ctx.createSuccessStatus();
    }

    protected void skipCurrentConstraintFor(IValidationContext ctx, Collection<AbstractDependenciesPkg> allPackages) {
        EObject target = this.getTarget(ctx);
        if (target instanceof SystemEngineering) {
            ctx.skipCurrentConstraintForAll((Collection)((SystemEngineering)target).getOwnedArchitectures());
        }
        ctx.skipCurrentConstraintForAll(allPackages);
    }

    protected IStatus createCycleFailureStatus(IValidationContext ctx, List<List<AbstractDependenciesPkg>> cycles) {
        ArrayList<ConstraintStatus> statuses = new ArrayList<ConstraintStatus>();
        for (List<AbstractDependenciesPkg> cycle : cycles) {
            IStatus status = ctx.createFailureStatus(new Object[]{this.toString(cycle)});
            statuses.add(ConstraintStatus.createStatus((IValidationContext)ctx, cycle, (String)status.getMessage(), (Object[])new Object[]{""}));
        }
        return ConstraintStatus.createMultiStatus((IValidationContext)ctx, statuses);
    }

    private void clearMaps() {
        this.ident2Object.clear();
        this.object2Ident.clear();
    }

    public List<List<AbstractDependenciesPkg>> getInterPackageCycles(EObject context) {
        return this.getInterPackageCycles(this.getAllPackages(context));
    }

    protected List<List<AbstractDependenciesPkg>> getInterPackageCycles(Collection<AbstractDependenciesPkg> allPkgs) {
        Set<AbstractDependenciesPkg> pkgsToCheck = new HashSet<AbstractDependenciesPkg>(allPkgs);
        HashMap<Integer, Set<Integer>> graphMap = new HashMap<Integer, Set<Integer>>();
        while (!(pkgsToCheck = this.buildPkgGraph(pkgsToCheck, allPkgs, graphMap)).isEmpty()) {
            allPkgs.addAll(pkgsToCheck);
        }
        Set[] graph = new HashSet[this.identifierCounter];
        int i = 0;
        while (i < this.identifierCounter) {
            HashSet x = (HashSet)graphMap.get(i);
            if (x == null) {
                x = new HashSet();
            }
            graph[i] = x;
            ++i;
        }
        TarjanAlgorithm t = new TarjanAlgorithm();
        List scComponents = t.getSCComponents(graph);
        ArrayList<List<AbstractDependenciesPkg>> cfcs = new ArrayList<List<AbstractDependenciesPkg>>();
        for (List list : scComponents) {
            if (list.size() <= 1) continue;
            ArrayList<AbstractDependenciesPkg> cfc = new ArrayList<AbstractDependenciesPkg>();
            for (Integer integer : list) {
                cfc.add(this.ident2Object.get(integer));
            }
            cfcs.add(cfc);
        }
        return cfcs;
    }

    protected Collection<AbstractDependenciesPkg> getAllPackages(EObject context) {
        if (context instanceof SystemEngineering) {
            return AbstractDependenciesPkgExt.getAllPackages((SystemEngineering)((SystemEngineering)context));
        }
        if (context instanceof AbstractDependenciesPkg || context instanceof BlockArchitecture) {
            ArrayList<AbstractDependenciesPkg> returnedList = new ArrayList<AbstractDependenciesPkg>();
            returnedList.addAll(DataPkgExt.getAllDataPkgsInCurrentBlockArchitectures((EObject)context));
            returnedList.addAll(InterfacePkgExt.getAllInterfacePkgsInCurrentBlockArchitectures((EObject)context));
            return returnedList;
        }
        return Collections.emptyList();
    }

    protected Set<AbstractDependenciesPkg> buildPkgGraph(Collection<AbstractDependenciesPkg> pkgsToCheck, Collection<AbstractDependenciesPkg> allPkgs, Map<Integer, Set<Integer>> graph) {
        HashSet<AbstractDependenciesPkg> newObjects = new HashSet<AbstractDependenciesPkg>();
        for (AbstractDependenciesPkg pkgToCheck : pkgsToCheck) {
            HashSet<Integer> dependentPkgIdentifiers = new HashSet<Integer>();
            graph.put(this.getObjectIdentifier(pkgToCheck), dependentPkgIdentifiers);
            for (AbstractDependenciesPkg dependentPkg : this.getPkgDependencies(pkgToCheck)) {
                if (!allPkgs.contains(dependentPkg)) {
                    newObjects.add(dependentPkg);
                }
                dependentPkgIdentifiers.add(this.getObjectIdentifier(dependentPkg));
            }
        }
        return newObjects;
    }

    protected Collection<AbstractDependenciesPkg> getPkgDependencies(AbstractDependenciesPkg pkgToCheck) {
        return AbstractDependenciesPkgExt.getDependencies((AbstractDependenciesPkg)pkgToCheck);
    }

    private Integer getObjectIdentifier(AbstractDependenciesPkg object) {
        return this.object2Ident.computeIfAbsent(object, f -> {
            Integer res = this.identifierCounter;
            ++this.identifierCounter;
            this.ident2Object.put(res, object);
            return res;
        });
    }

    protected String toString(List<AbstractDependenciesPkg> cycle) {
        StringBuilder builder = new StringBuilder();
        int count = 0;
        Iterator<AbstractDependenciesPkg> iterator = cycle.iterator();
        while (iterator.hasNext()) {
            builder.append(iterator.next().getName());
            if (iterator.hasNext() && ++count < 3) {
                builder.append(", ");
                continue;
            }
            if (!iterator.hasNext()) break;
            builder.append(" ...");
            break;
        }
        return builder.toString();
    }
}

