/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.tools.report.appenders.reportlogview;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.mdsofa.common.constant.ICommonConstants;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.IMarkerSource;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.IMarkerSourceListener;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerViewPlugin;

public class LightMarkerRegistry
implements IMarkerSource {
    private static final LightMarkerRegistry _instance = new LightMarkerRegistry();
    private List<IMarker> _registry = Collections.synchronizedList(new ArrayList());
    List<IContentProvider> legacyObservers = Collections.synchronizedList(new ArrayList());
    List<IMarkerSourceListener> listeners = Collections.synchronizedList(new ArrayList());

    public static LightMarkerRegistry getInstance() {
        return _instance;
    }

    protected List<IContentProvider> getObservers() {
        return this.legacyObservers;
    }

    @Deprecated
    void addObserver(IContentProvider observer) {
        this.getObservers().add(observer);
    }

    @Deprecated
    void removeObserver(IContentProvider observer) {
        this.getObservers().remove(observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyRegistryChanged(IMarker oldValue, IMarker newValue) {
        List<IContentProvider> oldObservers;
        List<Object> list = oldObservers = this.getObservers();
        synchronized (list) {
            for (IContentProvider observer : oldObservers) {
                observer.inputChanged(null, (Object)oldValue, (Object)newValue);
            }
        }
        list = this.listeners;
        synchronized (list) {
            if (oldValue == null && newValue != null) {
                for (IMarkerSourceListener listener : this.listeners) {
                    listener.markerAdded(newValue);
                }
            } else if (oldValue != null && newValue == null) {
                for (IMarkerSourceListener listener : this.listeners) {
                    listener.markerDeleted(oldValue);
                }
            }
        }
    }

    public IMarker createMarker(IResource fileResource, Diagnostic diagnostic) {
        return this.createMarker(fileResource, diagnostic, "org.polarsys.capella.common.tools.report.appenders.reportlogview.logview");
    }

    public IMarker createMarker(IResource fileResource, Diagnostic diagnostic, String markerType) {
        return this.createMarker(fileResource, diagnostic, markerType, null);
    }

    public IMarker createMarker(IResource fileResource, Diagnostic diagnostic, String markerType, IMarkerModification modification) {
        LightMarker marker = new LightMarker(fileResource, markerType, diagnostic);
        if (modification != null) {
            modification.modify(marker);
        }
        this._registry.add(marker);
        this.notifyRegistryChanged(null, marker);
        return marker;
    }

    public boolean hasMarkers() {
        return !this._registry.isEmpty();
    }

    @Override
    public Collection<IMarker> getMarkers() {
        return Collections.unmodifiableCollection(this._registry);
    }

    public void purgeMarkers() {
        Iterator<IMarker> markers = this._registry.iterator();
        while (markers.hasNext()) {
            IMarker marker = markers.next();
            if (!this.isPurgeable(marker)) continue;
            try {
                markers.remove();
                marker.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected boolean isPurgeable(IMarker marker) {
        return marker instanceof LightMarker && ((LightMarker)marker).isPurgeable();
    }

    @Override
    public void addListener(IMarkerSourceListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IMarkerSourceListener listener) {
        this.listeners.remove(listener);
    }

    public static interface IMarkerModification {
        public void modify(IMarker var1);
    }

    public class LightMarker
    implements IMarker {
        HashMap<String, Object> attributes = new HashMap();
        String type;
        long id;
        long creationTime;
        IResource resource;
        private Diagnostic diagnostic;

        public LightMarker(IResource resource, String markerType, Diagnostic diagnostic) {
            this.resource = resource;
            this.diagnostic = diagnostic;
            this.id = System.nanoTime();
            this.type = markerType;
            this.creationTime = System.currentTimeMillis();
        }

        public boolean isPurgeable() {
            if (this.diagnostic.getData().isEmpty()) {
                return false;
            }
            boolean purgeable = false;
            if (this.diagnostic.getSource() != null && this.diagnostic.getSource().equals("org.eclipse.emf.ecore")) {
                for (Object o : this.diagnostic.getData()) {
                    if (!(o instanceof EObject) || ((EObject)o).eResource() != null || ((EObject)o).eIsProxy()) continue;
                    purgeable = true;
                    break;
                }
            } else {
                for (Object o : this.diagnostic.getData()) {
                    if (!(o instanceof EObject) || ((EObject)o).eResource() != null) continue;
                    purgeable = true;
                    break;
                }
            }
            return purgeable;
        }

        public void delete() throws CoreException {
            LightMarkerRegistry.this._registry.remove(this);
            LightMarkerRegistry.this.notifyRegistryChanged(this, null);
        }

        public boolean exists() {
            return LightMarkerRegistry.this._registry.contains(this);
        }

        public Object getAttribute(String attributeName) throws CoreException {
            Object attribute = this.attributes.get(attributeName);
            if (attribute != null) {
                return attribute;
            }
            if ("message".equals(attributeName)) {
                return this.diagnostic.getMessage();
            }
            if ("severity".equals(attributeName)) {
                if (this.diagnostic.getSeverity() < 2) {
                    return 0;
                }
                if (this.diagnostic.getSeverity() < 4) {
                    return 1;
                }
                return 2;
            }
            if ("ruleId".equals(attributeName)) {
                return this.diagnostic.getMessage();
            }
            if ("org.eclipse.ui.views.markers.path".equals(attributeName)) {
                String pathAttributes = "";
                for (Object data : this.diagnostic.getData()) {
                    ModelElement element;
                    Session session;
                    if (!(data instanceof ModelElement) || (session = SessionManager.INSTANCE.getSession((EObject)(element = (ModelElement)data))) == null) continue;
                    pathAttributes = String.valueOf(pathAttributes) + element.getFullLabel() + ICommonConstants.LINE_SEPARATOR;
                }
                return pathAttributes;
            }
            return this.attributes.get(attributeName);
        }

        public int getAttribute(String attributeName, int defaultValue) {
            Object result = null;
            try {
                result = this.getAttribute(attributeName);
            }
            catch (CoreException e) {
                MarkerViewPlugin.getDefault().getLog().log((IStatus)new Status(e.getStatus().getSeverity(), "org.polarsys.capella.common.tools.report.appenders.reportlogview", e.getMessage(), (Throwable)e));
            }
            if (result instanceof Integer) {
                return (Integer)result;
            }
            return defaultValue;
        }

        public String getAttribute(String attributeName, String defaultValue) {
            Object result = null;
            try {
                result = this.getAttribute(attributeName);
            }
            catch (CoreException e) {
                MarkerViewPlugin.getDefault().getLog().log((IStatus)new Status(e.getStatus().getSeverity(), "org.polarsys.capella.common.tools.report.appenders.reportlogview", e.getMessage(), (Throwable)e));
            }
            if (result instanceof String) {
                return (String)result;
            }
            return defaultValue;
        }

        public boolean getAttribute(String attributeName, boolean defaultValue) {
            Object result = null;
            try {
                result = this.getAttribute(attributeName);
            }
            catch (CoreException e) {
                MarkerViewPlugin.getDefault().getLog().log((IStatus)new Status(e.getStatus().getSeverity(), "org.polarsys.capella.common.tools.report.appenders.reportlogview", e.getMessage(), (Throwable)e));
            }
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            return defaultValue;
        }

        public Map getAttributes() throws CoreException {
            HashMap<String, Object> result = new HashMap<String, Object>(this.attributes);
            result.put("message", this.getAttribute("message"));
            result.put("severity", this.getAttribute("severity"));
            result.put("org.eclipse.ui.views.markers.path", this.getAttribute("org.eclipse.ui.views.markers.path"));
            return result;
        }

        public Object[] getAttributes(String[] attributeNames) throws CoreException {
            Object[] res = new Object[attributeNames.length];
            int i = 0;
            while (i < attributeNames.length) {
                res[i] = this.getAttribute(attributeNames[i]);
                ++i;
            }
            return res;
        }

        public long getCreationTime() throws CoreException {
            return this.creationTime;
        }

        public long getId() {
            return this.id;
        }

        public IResource getResource() {
            return this.resource;
        }

        public String getType() throws CoreException {
            return this.type;
        }

        public boolean isSubtypeOf(String superType) throws CoreException {
            return false;
        }

        public void setAttribute(String attributeName, int value) throws CoreException {
            this.attributes.put(attributeName, value);
        }

        public void setAttribute(String attributeName, Object value) throws CoreException {
            this.attributes.put(attributeName, value);
        }

        public void setAttribute(String attributeName, boolean value) throws CoreException {
            this.attributes.put(attributeName, value);
        }

        public void setAttributes(Map attributes) throws CoreException {
            for (Object key : attributes.keySet()) {
                if (key == null || !(key instanceof String)) continue;
                this.attributes.put((String)key, attributes.get(key));
            }
        }

        public void setAttributes(String[] attributeNames, Object[] values) throws CoreException {
            int i = 0;
            while (i < attributeNames.length) {
                String key = attributeNames[i];
                Object value = values[i];
                this.attributes.put(key, value);
                ++i;
            }
        }

        public Object getAdapter(Class adapter) {
            if (adapter == Diagnostic.class) {
                return this.diagnostic;
            }
            return null;
        }
    }

    class MarkerModificationState
    implements IMarkerModification {
        private IMarker theMarker;

        MarkerModificationState() {
        }

        @Override
        public void modify(IMarker marker) {
            this.theMarker = marker;
        }

        public IMarker getMarker() {
            return this.theMarker;
        }
    }
}

