/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.preferences.trasferers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferenceFilter;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.preferences.PreferenceTransferElement;
import org.eclipse.ui.internal.wizards.preferences.PreferencesMessages;
import org.eclipse.ui.internal.wizards.preferences.WizardPreferencesPage;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class WizardPreferencesTransfererExportPage
extends WizardPreferencesPage {
    private static final String PREFERENCESEXPORTPAGE1 = "preferencesExportPage1";

    protected WizardPreferencesTransfererExportPage(String name) {
        super(name);
        this.setTitle(PreferencesMessages.WizardPreferencesExportPage1_exportTitle);
        this.setDescription(PreferencesMessages.WizardPreferencesExportPage1_exportDescription);
    }

    public WizardPreferencesTransfererExportPage() {
        this(PREFERENCESEXPORTPAGE1);
    }

    protected String getOutputSuffix() {
        return ".epf";
    }

    protected String getDestinationValue() {
        String idealSuffix = this.getOutputSuffix();
        String destinationText = super.getDestinationValue();
        if (destinationText.length() != 0 && !destinationText.endsWith(File.separator)) {
            int dotIndex = destinationText.lastIndexOf(46);
            if (dotIndex != -1) {
                int pathSepIndex = destinationText.lastIndexOf(File.separator);
                if (pathSepIndex != -1 && dotIndex < pathSepIndex) {
                    destinationText = String.valueOf(destinationText) + idealSuffix;
                }
            } else {
                destinationText = String.valueOf(destinationText) + idealSuffix;
            }
        }
        return destinationText;
    }

    protected String getAllButtonText() {
        return PreferencesMessages.WizardPreferencesExportPage1_all;
    }

    protected String getChooseButtonText() {
        return PreferencesMessages.WizardPreferencesExportPage1_choose;
    }

    protected void createTransferArea(Composite composite) {
        this.createTransfersList(composite);
        this.createDestinationGroup(composite);
        this.createOptionsGroup(composite);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.ui.export_wizard_selection_wizard_page_context");
    }

    protected String getDestinationLabel() {
        return PreferencesMessages.WizardPreferencesExportPage1_file;
    }

    protected PreferenceTransferElement[] getTransfers() {
        PreferenceTransferElement[] elements = super.getTransfers();
        PreferenceTransferElement[] returnElements = new PreferenceTransferElement[elements.length];
        IPreferenceFilter[] filters = new IPreferenceFilter[1];
        IPreferencesService service = Platform.getPreferencesService();
        int count = 0;
        try {
            PreferenceTransferElement[] preferenceTransferElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                PreferenceTransferElement element = preferenceTransferElementArray[n2];
                filters[0] = element.getFilter();
                IPreferenceFilter[] matches = service.matches((IEclipsePreferences)service.getRootNode().node("instance"), filters);
                if (matches.length > 0) {
                    returnElements[count++] = element;
                }
                ++n2;
            }
            elements = new PreferenceTransferElement[count];
            System.arraycopy(returnElements, 0, elements, 0, count);
        }
        catch (CoreException e) {
            WorkbenchPlugin.log((String)e.getMessage(), (Throwable)e);
            return new PreferenceTransferElement[0];
        }
        return elements;
    }

    protected boolean transfer(IPreferenceFilter[] transfers) {
        File exportFile = new File(this.getDestinationValue());
        if (!this.ensureTargetIsValid(exportFile)) {
            return false;
        }
        if (transfers.length > 0) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (FileOutputStream fos = new FileOutputStream(exportFile);){
                    IPreferencesService service = Platform.getPreferencesService();
                    service.exportPreferences(service.getRootNode(), transfers, (OutputStream)fos);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | CoreException e) {
                WorkbenchPlugin.log((String)e.getMessage(), (Throwable)e);
                MessageDialog.open((int)1, (Shell)this.getControl().getShell(), (String)"", (String)e.getLocalizedMessage(), (int)0x10000000);
                return false;
            }
        }
        return true;
    }

    protected String getFileDialogTitle() {
        return PreferencesMessages.WizardPreferencesExportPage1_title;
    }

    protected int getFileDialogStyle() {
        return 0x10002000;
    }

    protected String getInvalidDestinationMessage() {
        return PreferencesMessages.WizardPreferencesExportPage1_noPrefFile;
    }

    protected boolean shouldSaveTransferAll() {
        return true;
    }

    public void handleEvent(Event e) {
        Widget source = e.widget;
        source.getData();
        this.handleDestinationBrowseButtonPressed();
        this.updatePageCompletion();
    }

    protected void handleDestinationBrowseButtonPressed() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ListSelectionDialog dlg = new ListSelectionDialog(window.getShell(), (Object)ResourcesPlugin.getWorkspace().getRoot(), (IStructuredContentProvider)new BaseWorkbenchContentProvider(), (ILabelProvider)new WorkbenchLabelProvider(), "Select the Project:");
        dlg.setTitle("Project Selection");
        dlg.open();
    }
}

