/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.preferences.configuration.project;

import java.net.URI;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.dialogs.WorkingSetGroup;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.polarsys.capella.core.model.handler.command.CapellaResourceNamingHelper;
import org.polarsys.capella.core.preferences.configuration.project.ProjectContentsLocationArea;

public class WizardProjectCreationPage
extends WizardPage {
    private String initialProjectFieldValue;
    private WorkingSetGroup workingSetGroup;
    private IStructuredSelection selection;
    protected static final String RESOURCE_WORKING_SET_ID = "org.eclipse.ui.resourceWorkingSetPage";
    protected static final String JAVA_WORKING_SET_ID = "org.eclipse.jdt.ui.JavaWorkingSetPage";
    Text projectNameField;
    private Listener nameModifyListener = new Listener(){

        public void handleEvent(Event e) {
            WizardProjectCreationPage.this.setLocationForSelection();
            boolean valid = WizardProjectCreationPage.this.validatePage();
            WizardProjectCreationPage.this.setPageComplete(valid);
        }
    };
    private ProjectContentsLocationArea locationArea;
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;

    public WizardProjectCreationPage(String pageName, IStructuredSelection selection) {
        super(pageName);
        this.selection = selection;
        this.setPageComplete(false);
    }

    protected ProjectContentsLocationArea handleDefaultProjectLocation(Composite composite) {
        return new ProjectContentsLocationArea(this.getErrorReporter(), composite);
    }

    public void createControl(Composite parent_p) {
        GridLayout layout = new GridLayout();
        Composite dialogAreaComposite = new Composite(parent_p, 0);
        dialogAreaComposite.setFont(parent_p.getFont());
        this.initializeDialogUnits((Control)dialogAreaComposite);
        dialogAreaComposite.setLayout((Layout)layout);
        dialogAreaComposite.setLayoutData((Object)new GridData(1808));
        ScrolledComposite scrolled = new ScrolledComposite(dialogAreaComposite, 784);
        Composite composite = new Composite((Composite)scrolled, 16);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(dialogAreaComposite.getFont());
        this.createProjectNameGroup(composite);
        this.locationArea = this.handleDefaultProjectLocation(composite);
        if (this.initialProjectFieldValue != null) {
            this.locationArea.updateProjectName(this.initialProjectFieldValue);
        }
        this.setButtonLayoutData(this.locationArea.getBrowseButton());
        this.createProjectApproachGroup(composite);
        this.setPageComplete(this.validatePage());
        this.setErrorMessage(null);
        this.setMessage(null);
        scrolled.setContent((Control)composite);
        scrolled.setLayoutData((Object)new GridData(4, 4, true, true));
        scrolled.setLayout((Layout)new GridLayout());
        scrolled.setExpandVertical(true);
        scrolled.setExpandHorizontal(true);
        scrolled.setMinSize(composite.computeSize(-1, -1));
        scrolled.setVisible(true);
        this.setControl((Control)dialogAreaComposite);
    }

    public WorkingSetGroup createWorkingSetGroup(Composite composite, IStructuredSelection selection, String[] supportedWorkingSetTypes) {
        if (this.workingSetGroup != null) {
            return this.workingSetGroup;
        }
        this.workingSetGroup = new WorkingSetGroup(composite, selection, supportedWorkingSetTypes);
        return this.workingSetGroup;
    }

    public IWorkingSet[] getSelectedWorkingSets() {
        return this.workingSetGroup == null ? new IWorkingSet[]{} : this.workingSetGroup.getSelectedWorkingSets();
    }

    protected void createProjectApproachGroup(Composite parent_p) {
        Group radioBox = new Group(parent_p, 0);
        radioBox.setLayoutData((Object)new GridData(768));
        radioBox.setLayout((Layout)new GridLayout());
        radioBox.setText("Description");
        new Label((Composite)radioBox, 0).setText("allow user to create a new Capella Project with Configuration Nature.");
        new Label((Composite)radioBox, 0).setText("The Capella Configuration project is used as a store of customized capella project preferences.");
    }

    protected ProjectContentsLocationArea.IErrorMessageReporter getErrorReporter() {
        return new ProjectContentsLocationArea.IErrorMessageReporter(){

            @Override
            public void reportError(String errorMessage) {
                boolean valid;
                WizardProjectCreationPage.this.setErrorMessage(errorMessage);
                boolean bl = valid = errorMessage == null;
                if (valid) {
                    valid = WizardProjectCreationPage.this.validatePage();
                }
                WizardProjectCreationPage.this.setPageComplete(valid);
            }
        };
    }

    private final void createProjectNameGroup(Composite parent) {
        Composite projectGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label projectLabel = new Label(projectGroup, 0);
        projectLabel.setText("");
        projectLabel.setFont(parent.getFont());
        this.projectNameField = new Text(projectGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.projectNameField.setLayoutData((Object)data);
        this.projectNameField.setFont(parent.getFont());
        if (this.initialProjectFieldValue != null) {
            this.projectNameField.setText(this.initialProjectFieldValue);
        }
        this.projectNameField.addListener(24, this.nameModifyListener);
    }

    public IPath getLocationPath() {
        return new Path(this.locationArea.getProjectLocation());
    }

    public URI getLocationURI() {
        return this.locationArea.getProjectLocationURI();
    }

    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
    }

    public String getProjectName() {
        if (this.projectNameField == null) {
            return this.initialProjectFieldValue;
        }
        return this.getProjectNameFieldValue();
    }

    private String getProjectNameFieldValue() {
        if (this.projectNameField == null) {
            return "";
        }
        return this.projectNameField.getText().trim();
    }

    public void setInitialProjectName(String name) {
        if (name == null) {
            this.initialProjectFieldValue = null;
        } else {
            this.initialProjectFieldValue = name.trim();
            if (this.locationArea != null) {
                this.locationArea.updateProjectName(name.trim());
            }
        }
    }

    void setLocationForSelection() {
        this.locationArea.updateProjectName(this.getProjectNameFieldValue());
    }

    protected boolean validatePage() {
        String projectFieldContents = this.getProjectNameFieldValue();
        if ("".equals(projectFieldContents)) {
            this.setErrorMessage(null);
            this.setMessage("");
            return false;
        }
        IStatus nameStatus = CapellaResourceNamingHelper.validateName((String)projectFieldContents, (int)4);
        if (!nameStatus.isOK()) {
            this.setErrorMessage(nameStatus.getMessage());
            return false;
        }
        IProject handle = this.getProjectHandle();
        if (handle.exists()) {
            this.setErrorMessage(IDEWorkbenchMessages.WizardNewProjectCreationPage_projectExistsMessage);
            return false;
        }
        String validLocationMessage = this.locationArea.checkValidLocation();
        if (validLocationMessage != null) {
            this.setErrorMessage(validLocationMessage);
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.projectNameField.setFocus();
        }
    }

    public boolean useDefaults() {
        return this.locationArea.isDefault();
    }
}

