/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.cs.ui.quickfix.resolver.command;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentFunctionalAllocation;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionExt;
import org.polarsys.capella.core.platform.sirius.ui.commands.CapellaDeleteCommand;

public class RemoveNonLeafFunctionAllocation
extends AbstractReadWriteCommand {
    private Component element;

    public RemoveNonLeafFunctionAllocation(Component element) {
        this.element = element;
    }

    public String getName() {
        return "Remove all non leaf allocated functions";
    }

    public void run() {
        CapellaDeleteCommand command;
        ArrayList<ComponentFunctionalAllocation> linksToRemove = new ArrayList<ComponentFunctionalAllocation>(1);
        EList functionalAllocations = this.element.getFunctionalAllocations();
        if (functionalAllocations.size() < 1) {
            return;
        }
        for (ComponentFunctionalAllocation functionalAllocation : functionalAllocations) {
            AbstractFunction function = functionalAllocation.getFunction();
            if (FunctionExt.isLeaf((AbstractFunction)function) || function == null) continue;
            linksToRemove.add(functionalAllocation);
        }
        if (!linksToRemove.isEmpty() && (command = new CapellaDeleteCommand(TransactionHelper.getExecutionManager(linksToRemove), linksToRemove, false, true, true)).canExecute()) {
            command.execute();
        }
    }
}

