/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.common.transposer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.polarsys.capella.core.transition.common.exception.TransitionException;
import org.polarsys.capella.core.transition.common.transposer.ExtendedAnalyzer;
import org.polarsys.capella.core.transition.common.transposer.ExtendedCadenceLauncher;
import org.polarsys.capella.core.transition.common.transposer.ExtendedRulesHandler;
import org.polarsys.capella.core.transition.common.transposer.ExtendedScheduler;
import org.polarsys.kitalpha.cadence.core.api.parameter.GenericParameter;
import org.polarsys.kitalpha.cadence.core.api.parameter.WorkflowActivityParameter;
import org.polarsys.kitalpha.transposer.TransposerCorePlugin;
import org.polarsys.kitalpha.transposer.analyzer.graph.Graph;
import org.polarsys.kitalpha.transposer.analyzer.graph.Vertex;
import org.polarsys.kitalpha.transposer.api.TransposerConfiguration;
import org.polarsys.kitalpha.transposer.generic.GenericTransposer;
import org.polarsys.kitalpha.transposer.rules.handler.api.IRulesHandler;
import org.polarsys.kitalpha.transposer.rules.handler.exceptions.mappings.purposes.NonExistingPurposeException;
import org.polarsys.kitalpha.transposer.rules.handler.exceptions.rules.RuleExecutionException;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;
import org.polarsys.kitalpha.transposer.scheduler.api.ITransposerTask;

public class ExtendedTransposer
extends GenericTransposer {
    protected ExtendedCadenceLauncher extendedCadenceLauncher;
    protected HashMap<IProgressMonitor, IStatus> statuses;

    public IContext getContext() {
        return this._context;
    }

    public void dispose() {
        if (this.statuses != null) {
            this.statuses.clear();
            this.statuses = null;
        }
        super.dispose();
    }

    public ExtendedTransposer(String purpose, String mappingId) {
        super(purpose, mappingId);
    }

    protected void setUp(String purpose, String mappingId) {
        super.setUp(purpose, mappingId);
        this.initCadence();
        this.statuses = new HashMap();
    }

    public void initCadence() {
        this.extendedCadenceLauncher = new ExtendedCadenceLauncher();
    }

    public void transpose(Collection<Object> selection, TransposerConfiguration configuration, Comparator<Vertex<?>> comparator, IProgressMonitor monitor) {
        try {
            Collection sources;
            ArrayList<Object> analysisSources = (ArrayList<Object>)this.getContext().get((Object)"TransposerAnalysisSources");
            if (analysisSources == null) {
                analysisSources = new ArrayList<Object>();
            }
            this.checkCancel(monitor);
            this.callPreAnalysisActivities(selection, analysisSources, configuration, monitor);
            this.checkCancel(monitor);
            if ((analysisSources == null || analysisSources.isEmpty()) && (sources = this._rulesHandler.getDomainHelper().getAnalysisSources(selection)) != null && !sources.isEmpty()) {
                analysisSources.addAll(sources);
            }
            Graph graph = this.getAnalyzer().analyze(analysisSources, selection, monitor);
            this.checkCancel(monitor);
            this.callPreSchedulingActivities(graph, configuration, monitor);
            this.checkCancel(monitor);
            this.getScheduler().setModel(graph);
            this.getScheduler().schedule(comparator, monitor);
            List scheduledTasks = this.getScheduler().getScheduleResult();
            this.checkCancel(monitor);
            this.callPreExecutionActivities(scheduledTasks, configuration, monitor);
            this.checkCancel(monitor);
            if (monitor != null) {
                monitor.beginTask("Transposer Tasks Execution", scheduledTasks.size());
            }
            for (ITransposerTask scheduledTask : scheduledTasks) {
                Vertex v = (Vertex)scheduledTask.getTaskContent();
                try {
                    this.getRulesHandler().apply(v.getContent(), scheduledTask.isCompletelyTransposable(), monitor);
                    this.checkCancel(monitor);
                }
                catch (RuleExecutionException e) {
                    TransposerCorePlugin.getDefault().logError("org.polarsys.kitalpha.transposer", String.valueOf(RuleExecutionException.class.getSimpleName()) + " on " + e.getMessage(), e.getCause());
                }
                if (monitor == null) continue;
                monitor.worked(1);
            }
            this.checkCancel(monitor);
            this.callPostExecutionActivities(configuration, monitor);
            this.checkCancel(monitor);
            if (monitor != null) {
                monitor.done();
            }
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TransitionException(e);
        }
    }

    protected void checkCancel(IProgressMonitor monitor) throws Exception {
        if (monitor.isCanceled()) {
            IStatus status = this.statuses.get(monitor);
            if (status != null && !status.matches(8)) {
                throw new TransitionException(status);
            }
            throw new OperationCanceledException();
        }
    }

    public void initAnalyzer() {
        this._analyzer = new ExtendedAnalyzer(this._rulesHandler);
    }

    public void initScheduler() {
        this._scheduler = new ExtendedScheduler();
    }

    protected IRulesHandler getRulesHandler(String purpose, String mappingId) throws NonExistingPurposeException {
        return new ExtendedRulesHandler(purpose, mappingId);
    }

    protected void callPreSchedulingActivities(Graph graph, TransposerConfiguration configuration, IProgressMonitor monitor) {
        if (configuration == null) {
            return;
        }
        this._cadenceParameters.addParameter(new GenericParameter("TransposerAnalysisGraph", (Object)graph, "Computed analysis graph"));
        this.complementActivitiesParameters(configuration.getPreSchedulingActivities());
        try {
            this.cadence("org.polarsys.kitalpha.transposer.workflow", "org.polarsys.kitalpha.transposer.before.scheduling", configuration.getPreSchedulingActivities(), monitor);
        }
        catch (Exception e) {
            throw new TransitionException(e);
        }
    }

    protected Set<?> getElements(Collection<ITransposerTask<Vertex<?>>> sortedTasks) {
        LinkedHashSet<Object> set = new LinkedHashSet<Object>();
        for (ITransposerTask<Vertex<?>> task : sortedTasks) {
            set.add(((Vertex)task.getTaskContent()).getContent());
        }
        return set;
    }

    protected void callPreExecutionActivities(Collection<ITransposerTask<Vertex<?>>> sortedTasks, TransposerConfiguration configuration, IProgressMonitor monitor) {
        if (configuration == null) {
            return;
        }
        this._cadenceParameters.addParameter(new GenericParameter("TransposerSortedTasks", sortedTasks, "Computed and sorted tasks list"));
        this._cadenceParameters.addParameter(new GenericParameter("TransposerTransposableObjects", this.getElements(sortedTasks), "Transposable elements"));
        this.complementActivitiesParameters(configuration.getPreExecutionActivities());
        try {
            this.cadence("org.polarsys.kitalpha.transposer.workflow", "org.polarsys.kitalpha.transposer.before.rule.execution", configuration.getPreExecutionActivities(), monitor);
        }
        catch (Exception e) {
            throw new TransitionException(e);
        }
    }

    public IStatus cadence(String workflow_id, String workflowElement_id, WorkflowActivityParameter workflowActivityParameters, IProgressMonitor monitor) throws Exception {
        IStatus result = this.extendedCadenceLauncher.cadence(workflow_id, workflowElement_id, workflowActivityParameters, monitor);
        if (result.matches(8) || result.matches(4)) {
            monitor.setCanceled(true);
            this.statuses.put(monitor, result);
        }
        return result;
    }

    protected void complementActivitiesParameters(WorkflowActivityParameter activities) {
        if (activities == null) {
            return;
        }
        for (String key : activities.getActivitiesID()) {
            if (this._cadenceParameters == null || this._cadenceParameters.getParameters().isEmpty()) continue;
            for (GenericParameter p : this._cadenceParameters.getParameters()) {
                activities.addParameter(key, p);
            }
        }
    }

    protected void callPostExecutionActivities(TransposerConfiguration configuration, IProgressMonitor monitor) {
        if (configuration == null) {
            return;
        }
        this.complementActivitiesParameters(configuration.getPostExecutionActivities());
        try {
            this.cadence("org.polarsys.kitalpha.transposer.workflow", "org.polarsys.kitalpha.transposer.after.rule.execution", configuration.getPostExecutionActivities(), monitor);
        }
        catch (Exception e) {
            throw new TransitionException(e);
        }
    }

    protected void callPreAnalysisActivities(Collection<Object> selection, Collection<Object> analysisSources, TransposerConfiguration configuration, IProgressMonitor monitor) {
        if (configuration == null) {
            return;
        }
        this._cadenceParameters.addParameter(new GenericParameter("TransposerInitialSelection", selection, "List of selected elements before Transposer's launch"));
        this._cadenceParameters.addParameter(new GenericParameter("TransposerSelection", selection, "List of selected elements before Transposer's launch"));
        this._cadenceParameters.addParameter(new GenericParameter("TransposerAnalysisSources", analysisSources, "List to store object required to start the analysis"));
        this._cadenceParameters.addParameter(new GenericParameter("TransposerContext", (Object)this._context, "Context used during rules execution"));
        this._cadenceParameters.addParameter(new GenericParameter("TransposerDomainHelper", (Object)this._rulesHandler.getDomainHelper(), "Domain Helper used by Transposer"));
        this.complementActivitiesParameters(configuration.getPreAnalysisActivities());
        try {
            this.cadence("org.polarsys.kitalpha.transposer.workflow", "org.polarsys.kitalpha.transposer.before.analysis", configuration.getPreAnalysisActivities(), monitor);
        }
        catch (Exception e) {
            throw new TransitionException(e);
        }
    }
}

