/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.common.launcher;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.polarsys.capella.core.transition.common.constants.Messages;
import org.polarsys.capella.core.transition.common.exception.TransitionException;
import org.polarsys.capella.core.transition.common.handlers.log.LogHelper;
import org.polarsys.capella.core.transition.common.transposer.ExtendedCadenceLauncher;
import org.polarsys.capella.core.transition.common.transposer.SharedWorkflowActivityParameter;
import org.polarsys.kitalpha.cadence.core.api.parameter.ActivityParameters;
import org.polarsys.kitalpha.cadence.core.api.parameter.GenericParameter;
import org.polarsys.kitalpha.cadence.core.api.parameter.WorkflowActivityParameter;

public class ActivitiesLauncher {
    protected ExtendedCadenceLauncher cadenceLauncher;
    protected HashMap<String, String> mapOverrides;
    protected SharedWorkflowActivityParameter parameters = new SharedWorkflowActivityParameter();
    private String name;

    public void initCadence() {
        this.cadenceLauncher = this.createCadenceLauncher();
    }

    public ActivitiesLauncher() {
        this.init();
    }

    protected void init() {
        this.initCadence();
        this.initOverrides();
    }

    protected void initOverrides() {
    }

    protected void addOverrides(String idOverrided, String idOverriding) {
        if (this.mapOverrides == null) {
            this.mapOverrides = new HashMap();
        }
        this.mapOverrides.put(idOverrided, idOverriding);
    }

    protected String getReportComponent() {
        return "Bridge";
    }

    protected String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected void processCancel() {
        LogHelper.getInstance().info("Operation has been cancelled", Messages.Activity_Transition);
    }

    protected ExtendedCadenceLauncher createCadenceLauncher() {
        return new ExtendedCadenceLauncher(){

            @Override
            protected String getStatusMessage(String workflowName, String workflowElementName) {
                return ActivitiesLauncher.this.getName();
            }

            @Override
            protected String getTaskName(String workflowName, String workflowElementName) {
                return ActivitiesLauncher.this.getName();
            }
        };
    }

    public void launch(Collection<?> selection, String purpose, String mappingId, IProgressMonitor monitor) {
    }

    protected String getWorkflow() {
        return "";
    }

    protected String[] getWorkflowElements(String workflowId) {
        return new String[0];
    }

    protected String[] getFinalWorkflowElements(String workflowId) {
        return new String[0];
    }

    protected WorkflowActivityParameter getParameter(String workflowId, String workflowElement) {
        return new WorkflowActivityParameter();
    }

    public void addParameters(SharedWorkflowActivityParameter parameters) {
        this.parameters.merge(parameters);
    }

    public void addParameter(String idActivity, GenericParameter<?> parameter) {
        this.parameters.addParameter(idActivity, parameter);
    }

    public void addSharedParameter(GenericParameter<?> parameter) {
        this.parameters.addSharedParameter(parameter);
    }

    public void removeSharedParameter(String parameterId) {
        this.parameters.removeSharedParameter(parameterId);
    }

    protected Iterator<String> iteratorWorkflowElements(String workflowId) {
        return new StringArrayIterator(this.getWorkflowElements(workflowId));
    }

    protected Iterator<String> iteratorFinalWorkflowElements(String workflowId) {
        return new StringArrayIterator(this.getFinalWorkflowElements(workflowId));
    }

    protected void triggerActivities(Collection<?> selection, String workflowId, IProgressMonitor monitor) {
        try {
            try {
                Iterator<String> iter = this.iteratorWorkflowElements(workflowId);
                while (iter.hasNext()) {
                    String workflowElement = iter.next();
                    WorkflowActivityParameter parameter = this.getParameter(workflowId, workflowElement);
                    this.mergeParameters(parameter, this.parameters);
                    IStatus status = this.triggerActivities(parameter, workflowId, workflowElement, monitor);
                    this.checkStatus(monitor, status);
                }
            }
            catch (OperationCanceledException | TransitionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TransitionException(e);
            }
        }
        finally {
            try {
                Iterator<String> iter = this.iteratorFinalWorkflowElements(workflowId);
                while (iter.hasNext()) {
                    String workflowElement = iter.next();
                    WorkflowActivityParameter parameter = this.getParameter(workflowId, workflowElement);
                    this.mergeParameters(parameter, this.parameters);
                    IStatus status = this.triggerActivities(parameter, workflowId, workflowElement, monitor);
                    this.checkStatus(monitor, status);
                }
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (TransitionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TransitionException(e);
            }
        }
    }

    protected WorkflowActivityParameter mergeParameters(WorkflowActivityParameter parameter, SharedWorkflowActivityParameter sharedParameter) {
        if (sharedParameter != null) {
            for (String idActivities : parameter.getActivitiesID()) {
                ActivityParameters ps = sharedParameter.getActivityParameters(idActivities);
                for (GenericParameter a : ps.getParameters()) {
                    parameter.addParameter(idActivities, a);
                }
            }
        }
        return parameter;
    }

    protected IStatus triggerActivities(WorkflowActivityParameter activities, String workflowId, String workflowElement, IProgressMonitor monitor) {
        try {
            return this.cadence(workflowId, workflowElement, activities, monitor);
        }
        catch (Exception e) {
            throw new TransitionException(e);
        }
    }

    public IStatus cadence(String workflow_id, String workflowElement_id, WorkflowActivityParameter workflowActivityParameters, IProgressMonitor monitor) throws Exception {
        IStatus result = this.cadenceLauncher.cadence(workflow_id, workflowElement_id, workflowActivityParameters, monitor);
        if (result.matches(8) || result.matches(4)) {
            monitor.setCanceled(true);
        }
        return result;
    }

    protected void checkStatus(IProgressMonitor monitor, IStatus status) throws Exception {
        if (monitor.isCanceled() && status != null) {
            if (status.matches(4)) {
                throw new TransitionException(status);
            }
            if (status.matches(8)) {
                throw new OperationCanceledException(status.getMessage());
            }
        }
    }

    protected String getActivity(String id) {
        if (this.mapOverrides != null && this.mapOverrides.containsKey(id)) {
            return this.getActivity(this.mapOverrides.get(id));
        }
        return id;
    }

    protected void dispose() {
    }

    public class StringArrayIterator
    implements Iterator<String> {
        private String[] array;
        private int pos = 0;

        public StringArrayIterator(String[] array) {
            this.array = array;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.array.length;
        }

        @Override
        public String next() throws NoSuchElementException {
            if (this.hasNext()) {
                return this.array[this.pos++];
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

