/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.diffdata.impl;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.diffmerge.diffdata.DiffdataPackage;
import org.eclipse.emf.diffmerge.diffdata.EComparison;
import org.eclipse.emf.diffmerge.diffdata.EMapping;
import org.eclipse.emf.diffmerge.diffdata.EMatch;
import org.eclipse.emf.diffmerge.generic.api.Role;
import org.eclipse.emf.diffmerge.generic.api.scopes.IEditableTreeDataScope;
import org.eclipse.emf.diffmerge.generic.api.scopes.ITreeDataScope;
import org.eclipse.emf.diffmerge.generic.gdiffdata.impl.GMappingImpl;
import org.eclipse.emf.diffmerge.structures.common.FArrayList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.ECrossReferenceEList;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class EMappingImpl
extends GMappingImpl<EObject, EAttribute, EReference>
implements EMapping {
    private final ScopeCrossReferencer _targetCrossReferencer = new ScopeCrossReferencer(this, Role.TARGET);
    private final ScopeCrossReferencer _referenceCrossReferencer = new ScopeCrossReferencer(this, Role.REFERENCE);
    private MatchCrossReferenceAdapter _matchAdapter = new MatchCrossReferenceAdapter();

    protected EMappingImpl() {
        this.eAdapters().add((Object)this._matchAdapter);
    }

    protected EClass eStaticClass() {
        return DiffdataPackage.Literals.EMAPPING;
    }

    public void clear() {
        this._targetCrossReferencer.clear();
        this._referenceCrossReferencer.clear();
        this.eAdapters().remove((Object)this._matchAdapter);
        this._matchAdapter = new MatchCrossReferenceAdapter();
        this.eAdapters().add((Object)this._matchAdapter);
    }

    @Override
    public void crossReference(Role role_p) {
        ScopeCrossReferencer referencer = role_p == Role.TARGET ? this._targetCrossReferencer : this._referenceCrossReferencer;
        referencer.crossReference();
    }

    @Override
    public EComparison getComparison() {
        return (EComparison)super.getComparison();
    }

    @Override
    public EList<EStructuralFeature.Setting> getCrossReferences(EObject element_p, Role role_p) {
        EList result = null;
        ScopeCrossReferencer referencer = null;
        if (role_p == Role.TARGET) {
            referencer = this._targetCrossReferencer;
        } else if (role_p == Role.REFERENCE) {
            referencer = this._referenceCrossReferencer;
        }
        if (referencer != null) {
            result = (EList)referencer.get(element_p);
        }
        if (result == null) {
            result = ECollections.emptyEList();
        }
        return result;
    }

    @Override
    public EMatch getMatchFor(Object element_p, Role role_p) {
        EMatch result = null;
        if (role_p != null && element_p instanceof EObject) {
            EReference matchReference;
            switch (role_p) {
                case ANCESTOR: {
                    matchReference = DiffdataPackage.eINSTANCE.getEMatch_Ancestor();
                    break;
                }
                case REFERENCE: {
                    matchReference = DiffdataPackage.eINSTANCE.getEMatch_Reference();
                    break;
                }
                default: {
                    matchReference = DiffdataPackage.eINSTANCE.getEMatch_Target();
                }
            }
            Collection settings = this._matchAdapter.getNonNavigableInverseReferences((EObject)element_p);
            for (EStructuralFeature.Setting setting : settings) {
                if (setting.getEStructuralFeature() != matchReference) continue;
                result = (EMatch)setting.getEObject();
                break;
            }
        }
        return result;
    }

    @Override
    public EMatch map(EObject element, Role role) {
        return (EMatch)super.map((Object)element, role);
    }

    protected boolean doDisconnect(Role role_p, EObject element_p) {
        boolean result = true;
        IEditableTreeDataScope scope = this.getComparison().getScope(role_p);
        for (EStructuralFeature.Setting setting : this.getCrossReferences(element_p, role_p)) {
            boolean removed = scope.removeReferenceValue((Object)setting.getEObject(), (Object)setting.getEStructuralFeature(), (Object)element_p);
            boolean bl = result = result && removed;
        }
        return result;
    }

    protected static class MatchCrossReferenceAdapter
    extends ECrossReferenceAdapter {
        protected MatchCrossReferenceAdapter() {
        }

        protected boolean isIncluded(EReference reference_p) {
            return reference_p == DiffdataPackage.eINSTANCE.getEMatch_Ancestor() || reference_p == DiffdataPackage.eINSTANCE.getEMatch_Reference() || reference_p == DiffdataPackage.eINSTANCE.getEMatch_Target();
        }
    }

    protected static class ScopeCrossReferencer
    extends EcoreUtil.CrossReferencer {
        protected final EMapping _mapping;
        protected final Role _role;
        private ITreeDataScope<EObject> _scope;

        public ScopeCrossReferencer(EMapping mapping_p, Role role_p) {
            super(Collections.emptyList());
            this._mapping = mapping_p;
            this._role = role_p;
            this._scope = null;
        }

        public void crossReference() {
            super.crossReference();
        }

        protected boolean crossReference(EObject element_p, EReference reference_p, EObject crossReferenced_p) {
            return this._mapping.isIgnoredReferenceValue(element_p, reference_p, crossReferenced_p, this.getRole());
        }

        protected EContentsEList.FeatureIterator<EObject> getCrossReferences(EObject eObject) {
            return new ECrossReferenceEList.FeatureIteratorImpl<EObject>(eObject){

                protected boolean isIncluded(EStructuralFeature feature_p) {
                    return super.isIncludedEntry(feature_p) && this.getScope().tIsReferenceDisconnectionRequired((Object)feature_p);
                }

                protected boolean resolve() {
                    return this.resolve();
                }
            };
        }

        public Role getRole() {
            return this._role;
        }

        protected ITreeDataScope<EObject> getScope() {
            if (this._scope == null) {
                this._scope = this._mapping.getComparison().getScope(this.getRole());
            }
            return this._scope;
        }

        protected Collection<EStructuralFeature.Setting> newCollection() {
            return new FArrayList();
        }

        protected TreeIterator<Notifier> newContentsIterator() {
            return this._mapping.getComparison().getScope(this._role).iterator();
        }

        protected boolean resolve() {
            return false;
        }
    }
}

