/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.internal.navigate;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IMarker;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerViewHelper;
import org.polarsys.capella.common.ui.toolkit.browser.category.CategoryRegistry;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.model.handler.helpers.CapellaAdapterHelper;

public class NavigationAdvisor {
    private static NavigationAdvisor singleton;

    private NavigationAdvisor() {
    }

    public Set<EObject> getNavigableElements(Object receiver) {
        Part part;
        AbstractType partType;
        if (receiver instanceof IMarker) {
            return MarkerViewHelper.getModelElementsFromMarker((IMarker)((IMarker)receiver)).stream().filter(Objects::nonNull).collect(Collectors.toSet());
        }
        EObject element = CapellaAdapterHelper.resolveSemanticObject((Object)receiver);
        Set<EObject> navigableElements = this.computeNavigableElements(element);
        if (element instanceof Part && (partType = (part = (Part)element).getAbstractType()) instanceof Component) {
            navigableElements.addAll(this.computeNavigableElements((EObject)partType));
            navigableElements.remove(part);
        }
        return navigableElements;
    }

    private Set<EObject> computeNavigableElements(EObject element) {
        CategoryRegistry categoryRegistry = CategoryRegistry.getInstance();
        List categories = categoryRegistry.gatherRelatedElementsCategories(element);
        return categories.stream().flatMap(category -> category.compute((Object)element).stream()).filter(EObject.class::isInstance).map(EObject.class::cast).collect(Collectors.toSet());
    }

    public static NavigationAdvisor getInstance() {
        if (singleton == null) {
            singleton = new NavigationAdvisor();
        }
        return singleton;
    }
}

