/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.actions.providers;

import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.amalgam.explorer.activity.ui.api.actions.OpenSessionAction;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.SelectionHelper;
import org.polarsys.capella.core.sirius.ui.actions.CloseSessionAction;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;

public class AirdCommonActionProvider
extends CommonActionProvider {
    private org.polarsys.capella.core.sirius.ui.actions.OpenSessionAction openSessionAction;
    private CloseSessionAction closeSessionAction;
    private ActionFactory.IWorkbenchAction saveAction;

    public void dispose() {
        ISelectionProvider selectionProvider = this.getActionSite().getViewSite().getSelectionProvider();
        if (this.openSessionAction != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.openSessionAction);
            this.openSessionAction = null;
        }
        if (this.closeSessionAction != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.closeSessionAction);
            this.closeSessionAction = null;
        }
        if (this.saveAction != null) {
            this.saveAction.dispose();
            this.saveAction = null;
        }
        super.dispose();
    }

    public void init(ICommonActionExtensionSite site) {
        super.init(site);
        ISelectionProvider selectionProvider = site.getViewSite().getSelectionProvider();
        this.openSessionAction = new org.polarsys.capella.core.sirius.ui.actions.OpenSessionAction();
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this.openSessionAction, selectionProvider);
        this.closeSessionAction = new CloseSessionAction();
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this.closeSessionAction, selectionProvider);
        ICommonViewerSite commonViewSite = site.getViewSite();
        if (!(commonViewSite instanceof ICommonViewerWorkbenchSite)) {
            return;
        }
        ICommonViewerWorkbenchSite commonViewerWorkbenchSite = (ICommonViewerWorkbenchSite)commonViewSite;
        this.saveAction = ActionFactory.SAVE.create(commonViewerWorkbenchSite.getWorkbenchWindow());
    }

    public void fillActionBars(IActionBars actionBars) {
        if (this.openSessionAction.isEnabled()) {
            actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.openSessionAction);
        }
        actionBars.setGlobalActionHandler(ActionFactory.CLOSE.getId(), (IAction)this.closeSessionAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        this.updateActionBars();
        menu.appendToGroup("group.open", (IAction)this.openSessionAction);
        menu.appendToGroup("group.build", (IAction)this.closeSessionAction);
        menu.appendToGroup("group.build", (IAction)this.saveAction);
    }

    public void updateActionBars() {
        IStructuredSelection structuredSelection = (IStructuredSelection)this.getContext().getSelection();
        Iterator selectedElements = structuredSelection.iterator();
        boolean canOpen = true;
        boolean canClose = true;
        boolean canSelectViewpoints = true;
        while (selectedElements.hasNext()) {
            Object selectedElement = selectedElements.next();
            if (!(selectedElement instanceof IFile) || !((IFile)selectedElement).getFileExtension().equals("aird")) continue;
            IFile airdFile = (IFile)selectedElement;
            Session session = SessionHelper.getSessionForDiagramFile((IFile)airdFile);
            if (session == null) {
                canSelectViewpoints &= false;
                canClose &= false;
            } else {
                canOpen &= false;
            }
            if (!CapellaResourceHelper.isProjectOfType((IProject)airdFile.getProject(), Arrays.asList("org.polarsys.capella.project.nature", "org.polarsys.capella.library.nature"))) {
                this.openSessionAction.setOpenActivityExplorer(false);
                continue;
            }
            boolean toOpen = OpenSessionAction.getActivityExplorerPreference();
            this.openSessionAction.setOpenActivityExplorer(toOpen);
        }
        this.openSessionAction.setEnabled(canOpen);
        this.closeSessionAction.setEnabled(canClose);
    }
}

