/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties.richtext;

import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.polarsys.capella.core.ui.properties.richtext.CapellaMDERichTextConstants;
import org.polarsys.capella.core.ui.properties.richtext.clipboard.RichTextLinksClipboard;
import org.polarsys.capella.core.ui.properties.richtext.handlers.OpenInEditorHandler;
import org.polarsys.capella.core.ui.properties.richtext.handlers.PasteAsDescriptionLinkHandler;
import org.polarsys.kitalpha.richtext.common.intf.MDERichTextWidget;
import org.polarsys.kitalpha.richtext.nebula.widget.MDENebulaBasedRichTextWidget;
import org.polarsys.kitalpha.richtext.nebula.widget.MDENebulaRichTextConfiguration;
import org.polarsys.kitalpha.richtext.nebula.widget.toolbar.MDERichTextToolbarItemHandler;
import org.polarsys.kitalpha.richtext.widget.factory.MDERichTextFactory;

public class CapellaMDERichTextFactory
extends MDERichTextFactory {
    public MDERichTextWidget createMinimalRichTextWidget(Composite parent) {
        MDERichTextWidget widget = super.createMinimalRichTextWidget(parent);
        this.installKeyListener(widget);
        return widget;
    }

    public MDERichTextWidget createDefaultRichTextWidget(Composite parent) {
        MDERichTextWidget widget = super.createDefaultRichTextWidget(parent);
        this.installKeyListener(widget);
        return widget;
    }

    public MDERichTextWidget createEditorRichTextWidget(Composite parent) {
        MDERichTextWidget widget = super.createEditorRichTextWidget(parent);
        this.installKeyListener(widget);
        return widget;
    }

    protected MDERichTextFactory initializeMDEMinimalToolbar() {
        MDERichTextFactory factory = super.initializeMDEMinimalToolbar();
        MDENebulaRichTextConfiguration configuration = (MDENebulaRichTextConfiguration)this.getConfiguration();
        configuration.removeToolbarItems(new String[]{"Subscript", "Superscript", "openEditor"});
        return factory;
    }

    protected MDERichTextFactory initializeMDEDefaultToolbar(boolean addOpenInEditor) {
        MDERichTextFactory factory = super.initializeMDEDefaultToolbar(addOpenInEditor);
        MDENebulaRichTextConfiguration configuration = (MDENebulaRichTextConfiguration)this.getConfiguration();
        configuration.removeToolbarItems(new String[]{"Subscript", "Superscript", "openEditor"});
        return factory;
    }

    protected void addEditorToolbarItems(MDENebulaBasedRichTextWidget widget) {
        super.addEditorToolbarItems(widget);
        widget.addToolbarItem((MDERichTextWidget)widget, "PasteAsLink", "PasteAsLink", "Paste as Link (Ctrl + Shift + V)", "clipboard", CapellaMDERichTextConstants.PASTE_AS_LINK_ICON, (MDERichTextToolbarItemHandler)new PasteAsDescriptionLinkHandler());
        widget.addToolbarItem((MDERichTextWidget)widget, "OpenInEditor", "OpenInEditor", "Open in Editor", "enableEdit", CapellaMDERichTextConstants.OPEN_IN_EDITOR_ICON, (MDERichTextToolbarItemHandler)new OpenInEditorHandler());
    }

    protected void installKeyListener(final MDERichTextWidget widget) {
        KeyAdapter keyListener = new KeyAdapter(){
            private static final int SHIFT_AND_CTRL_KEY_CODE = 393216;
            private static final int V_KEY_CODE = 86;

            private boolean isPasteElementLinkEvent(KeyEvent event) {
                return (event.stateMask & 0x60000) == 393216 && event.keyCode == 86;
            }

            public void keyPressed(KeyEvent event) {
                if (this.isPasteElementLinkEvent(event)) {
                    widget.insertRawText(RichTextLinksClipboard.getInstance().getCopiedElementsLinksHtml());
                }
            }
        };
        widget.addKeyListener((KeyListener)keyListener);
    }
}

