/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.mdsofa.common.helper.StringHelper;
import org.polarsys.capella.core.platform.sirius.ui.commands.Messages;

public class NameCollisionHelper {
    public static final Pattern COPYOF_PATTERN = Pattern.compile("Copy \\((\\d)*\\) of (.*)");
    private Pattern pattern;
    private static NameCollisionHelper instance;

    public NameCollisionHelper(Pattern pattern) {
        this.pattern = pattern;
    }

    public static NameCollisionHelper getDefault() {
        if (instance == null) {
            instance = new NameCollisionHelper(COPYOF_PATTERN);
        }
        return instance;
    }

    public Collection<AbstractNamedElement> findConflictingElements(Collection<?> existing, Collection<?> candidates) {
        ArrayList<AbstractNamedElement> result = new ArrayList<AbstractNamedElement>(0);
        for (Object candidate : candidates) {
            if (!(candidate instanceof AbstractNamedElement) || !this.isCollide(existing, ((AbstractNamedElement)candidate).getName())) continue;
            result.add((AbstractNamedElement)candidate);
        }
        return result;
    }

    public void handleNamingCollision(Collection<? extends AbstractNamedElement> objects, EObject owner) {
        for (AbstractNamedElement abstractNamedElement : objects) {
            if (abstractNamedElement == null) continue;
            String name = abstractNamedElement.getName();
            boolean firstAttempt = true;
            EList eContents = owner.eContents();
            while (this.isCollide((Collection<?>)eContents, name)) {
                Matcher patternMatcher = this.pattern.matcher(name);
                if (firstAttempt) {
                    name = String.valueOf(Messages.CapellaPasteCommand_COPY_OF) + name;
                    firstAttempt = false;
                    continue;
                }
                if (name.startsWith(Messages.CapellaPasteCommand_COPY_OF)) {
                    name = String.valueOf(Messages.CapellaPasteCommand_COPY_2_OF) + name.substring(Messages.CapellaPasteCommand_COPY_OF.length());
                    continue;
                }
                if (!patternMatcher.matches()) continue;
                String numberAsString = StringHelper.substring((String)"(", (String)")", (String)name, (boolean)false);
                int number = Integer.parseInt(numberAsString) + 1;
                name = NLS.bind((String)Messages.CapellaPasteCommand_COPY_MULTIPLE, (Object[])new String[]{String.valueOf(number), patternMatcher.group(2)});
            }
            abstractNamedElement.setName(name);
        }
    }

    public boolean isCollide(Collection<?> modelElements, String name) {
        for (Object object : modelElements) {
            AbstractNamedElement element;
            if (!(object instanceof AbstractNamedElement) || (element = (AbstractNamedElement)object).getName() == null || !element.getName().equals(name)) continue;
            return true;
        }
        return false;
    }
}

