/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.widgets.filter;

import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.progress.WorkbenchJob;
import org.polarsys.capella.common.ui.toolkit.widgets.filter.CapellaPatternFilter;
import org.polarsys.capella.common.ui.toolkit.widgets.filter.Messages;

public class CapellaFilteredTree
extends FilteredTree {
    int levelOfExpandByDefault = -1;

    public CapellaFilteredTree(Composite parent, int treeStyle, CapellaPatternFilter filter) {
        super(parent, treeStyle, (PatternFilter)filter, true);
    }

    protected WorkbenchJob doCreateRefreshJob() {
        WorkbenchJob refreshJob = super.doCreateRefreshJob();
        final CapellaFilteredTree tree = this;
        refreshJob.addJobChangeListener(new IJobChangeListener(){
            ISelection selectionBeforeRefresh;

            public void sleeping(IJobChangeEvent event) {
            }

            public void scheduled(IJobChangeEvent event) {
                this.selectionBeforeRefresh = tree.getViewer().getSelection();
            }

            public void running(IJobChangeEvent event) {
            }

            public void done(IJobChangeEvent event) {
                if (tree.getFilterString().isEmpty()) {
                    tree.getViewer().expandToLevel(tree.levelOfExpandByDefault, true);
                    if (this.selectionBeforeRefresh != null) {
                        tree.getViewer().setSelection(this.selectionBeforeRefresh);
                    }
                }
            }

            public void awake(IJobChangeEvent event) {
            }

            public void aboutToRun(IJobChangeEvent event) {
            }
        });
        return refreshJob;
    }

    protected long getRefreshJobDelay() {
        return 0L;
    }

    protected void createFilterText(Composite parent) {
        super.createFilterText(parent);
        Listener[] modifyListeners = this.filterText.getListeners(24);
        int i = 0;
        while (i < modifyListeners.length) {
            this.filterText.removeListener(24, modifyListeners[i]);
            ++i;
        }
        Listener[] traverseListeners = this.filterText.getListeners(31);
        int i2 = 0;
        while (i2 < traverseListeners.length) {
            this.filterText.removeListener(31, traverseListeners[i2]);
            ++i2;
        }
        this.filterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    CapellaFilteredTree.this.textChanged();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
    }

    public void setLevelOfExpandByDefault(int levelOfExpandByDefault) {
        this.levelOfExpandByDefault = levelOfExpandByDefault;
    }

    public int getLevelOfExpandByDefault() {
        return this.levelOfExpandByDefault;
    }

    public void refresh() {
        if (!this.getFilterString().isEmpty()) {
            this.textChanged();
        }
    }

    public void setInitialText(String text) {
        super.setInitialText(Messages.CapellaFilteredTree_FILTER_TEXT_PLACEHOLDER);
    }

    public void setCaseSensitiveEnabled(boolean isSearchCaseSensitiveEnabled) {
        ((CapellaPatternFilter)this.getPatternFilter()).setCaseSensitiveEnabled(isSearchCaseSensitiveEnabled);
    }
}

