/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.services.wizard;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractWizardPage
extends WizardPage {
    private boolean _computeCompleteStatus;
    private boolean _completeStatus;

    public AbstractWizardPage(String pageName) {
        super(pageName);
        this.initialize();
    }

    public AbstractWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.initialize();
    }

    protected void initialize() {
        this._computeCompleteStatus = true;
    }

    public void createControl(Composite parent) {
        this.setTitle(this.getPageTitle());
        this.setDescription(this.getPageDescription());
        Composite content = this.createComposite(parent, this.getContentNumColumn());
        this.initializeDialogUnits((Control)content);
        this.handlePageContentEnablement(content);
        this.createPageArea(content);
        this.updateButtons();
        Point size = content.computeSize(-1, -1);
        GridData gridData = (GridData)parent.getLayoutData();
        gridData.heightHint = Math.max(size.y + 10, gridData.heightHint);
        String helpContextId = this.getHelpContextId();
        if (helpContextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)content, helpContextId);
        }
    }

    protected abstract void handlePageContentEnablement(Composite var1);

    public final void updateButtons() {
        this._computeCompleteStatus = true;
        this.setPageComplete(this.computeCompleteStatus());
    }

    public boolean isPageComplete() {
        return this.computeCompleteStatus();
    }

    protected abstract boolean getCompleteStatus();

    protected abstract void createPageArea(Composite var1);

    protected void handlePageLayout(Composite parent) {
    }

    protected int getContentNumColumn() {
        return 1;
    }

    protected abstract String getPageTitle();

    protected abstract String getPageDescription();

    protected String getHelpContextId() {
        return null;
    }

    private boolean computeCompleteStatus() {
        if (this._computeCompleteStatus) {
            this._completeStatus = this.getCompleteStatus();
            this._computeCompleteStatus = false;
        }
        return this._completeStatus;
    }

    private Composite createComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        composite.setLayout((Layout)layout);
        this.setControl((Control)composite);
        return composite;
    }

    public void performHelp() {
        String helpContextId = this.getHelpContextId();
        if (helpContextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().displayHelp(helpContextId);
        }
    }
}

