/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.fa.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentFunctionalAllocation;
import org.polarsys.capella.core.data.fa.FunctionInputPort;
import org.polarsys.capella.core.data.fa.FunctionOutputPort;
import org.polarsys.capella.core.data.fa.FunctionPort;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.data.information.PortRealization;

public class FunctionPortExt {
    public static List<Port> getRealizedPorts(FunctionPort fp) {
        ArrayList<Port> result = new ArrayList<Port>();
        for (AbstractTrace trace : fp.getOutgoingTraces()) {
            Port realizedPort;
            if (!(trace instanceof PortRealization) || (realizedPort = ((PortRealization)trace).getRealizedPort()) == null) continue;
            result.add(realizedPort);
        }
        return result;
    }

    public static List<Port> getRealizingPorts(FunctionPort fp) {
        ArrayList<Port> result = new ArrayList<Port>();
        for (AbstractTrace trace : fp.getIncomingTraces()) {
            Port realizingPort;
            if (!(trace instanceof PortRealization) || (realizingPort = ((PortRealization)trace).getRealizingPort()) == null) continue;
            result.add(realizingPort);
        }
        return result;
    }

    public static Set<ExchangeItem> getAllIncomingExchangeItems(FunctionPort fp) {
        HashSet<ExchangeItem> exchangesItems = new HashSet<ExchangeItem>();
        if (fp instanceof FunctionInputPort) {
            FunctionInputPort functionInputPort = (FunctionInputPort)fp;
            exchangesItems.addAll((Collection<ExchangeItem>)functionInputPort.getIncomingExchangeItems());
        } else if (fp instanceof FunctionOutputPort) {
            FunctionOutputPort functionOutputPort = (FunctionOutputPort)fp;
            exchangesItems.addAll((Collection<ExchangeItem>)functionOutputPort.getOutgoingExchangeItems());
        }
        return exchangesItems;
    }

    public static Set<Component> getAllProvidedRealizedRequiredInterfaces(FunctionPort fp) {
        HashSet<Component> exchangesItems = new HashSet<Component>();
        AbstractFunction abstractFunction = (AbstractFunction)fp.eContainer();
        EList componentFunctionalAllocation = abstractFunction.getComponentFunctionalAllocations();
        for (ComponentFunctionalAllocation componentFunctionalAllocation2 : componentFunctionalAllocation) {
            Component containerComponent = (Component)componentFunctionalAllocation2.getSourceElement();
            if (containerComponent == null) continue;
            exchangesItems.add(containerComponent);
        }
        return exchangesItems;
    }
}

