/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.fa.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.helpers.modellingcore.delegates.AbstractTypeHelper;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.InformationsExchanger;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeAllocation;
import org.polarsys.capella.core.data.fa.ComponentExchangeAllocator;
import org.polarsys.capella.core.data.fa.ComponentExchangeEnd;
import org.polarsys.capella.core.data.fa.ComponentExchangeFunctionalExchangeAllocation;
import org.polarsys.capella.core.data.fa.ComponentExchangeRealization;
import org.polarsys.capella.core.data.fa.ExchangeSpecification;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.helpers.fa.delegates.ExchangeSpecificationHelper;
import org.polarsys.capella.core.data.helpers.information.delegates.AbstractEventOperationHelper;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.information.Port;

public class ComponentExchangeHelper {
    private static ComponentExchangeHelper instance;

    private ComponentExchangeHelper() {
    }

    public static ComponentExchangeHelper getInstance() {
        if (instance == null) {
            instance = new ComponentExchangeHelper();
        }
        return instance;
    }

    public Object doSwitch(ComponentExchange element, EStructuralFeature feature) {
        Object ret = null;
        if (feature.equals(FaPackage.Literals.COMPONENT_EXCHANGE__ALLOCATED_FUNCTIONAL_EXCHANGES)) {
            ret = this.getAllocatedFunctionalExchanges(element);
        } else if (feature.equals(FaPackage.Literals.COMPONENT_EXCHANGE__INCOMING_COMPONENT_EXCHANGE_REALIZATIONS)) {
            ret = this.getIncomingComponentExchangeRealizations(element);
        } else if (feature.equals(FaPackage.Literals.COMPONENT_EXCHANGE__OUTGOING_COMPONENT_EXCHANGE_REALIZATIONS)) {
            ret = this.getOutgoingComponentExchangeRealizations(element);
        } else if (feature.equals(FaPackage.Literals.COMPONENT_EXCHANGE__OUTGOING_COMPONENT_EXCHANGE_FUNCTIONAL_EXCHANGE_ALLOCATIONS)) {
            ret = this.getOutgoingComponentExchangeFunctionalExchangeAllocations(element);
        } else if (feature.equals(FaPackage.Literals.COMPONENT_EXCHANGE__SOURCE_PART)) {
            ret = this.getSourcePart(element);
        } else if (feature.equals(FaPackage.Literals.COMPONENT_EXCHANGE__SOURCE_PORT)) {
            ret = this.getSourcePort(element);
        } else if (feature.equals(FaPackage.Literals.COMPONENT_EXCHANGE__TARGET_PART)) {
            ret = this.getTargetPart(element);
        } else if (feature.equals(FaPackage.Literals.COMPONENT_EXCHANGE__TARGET_PORT)) {
            ret = this.getTargetPort(element);
        } else if (feature.equals(FaPackage.Literals.COMPONENT_EXCHANGE__ALLOCATOR_PHYSICAL_LINKS)) {
            ret = this.getAllocatorPhysicalLinks(element);
        } else if (feature.equals(FaPackage.Literals.COMPONENT_EXCHANGE__REALIZED_COMPONENT_EXCHANGES)) {
            ret = this.getRealizedComponentExchanges(element);
        } else if (feature.equals(FaPackage.Literals.COMPONENT_EXCHANGE__REALIZING_COMPONENT_EXCHANGES)) {
            ret = this.getRealizingComponentExchanges(element);
        } else if (feature.equals(FaPackage.Literals.COMPONENT_EXCHANGE__CATEGORIES)) {
            ret = this.getCategories(element);
        }
        if (ret == null) {
            ret = AbstractTypeHelper.getInstance().doSwitch((AbstractType)element, feature);
        }
        if (ret == null) {
            ret = ExchangeSpecificationHelper.getInstance().doSwitch((ExchangeSpecification)element, feature);
        }
        if (ret == null) {
            ret = AbstractEventOperationHelper.getInstance().doSwitch((AbstractEventOperation)element, feature);
        }
        return ret;
    }

    protected List<EObject> getCategories(ComponentExchange element) {
        return EObjectExt.getReferencers((EObject)element, (EReference)FaPackage.Literals.COMPONENT_EXCHANGE_CATEGORY__EXCHANGES);
    }

    protected List<ComponentExchangeRealization> getIncomingComponentExchangeRealizations(ComponentExchange element) {
        ArrayList<ComponentExchangeRealization> ret = new ArrayList<ComponentExchangeRealization>();
        for (AbstractTrace trace : element.getIncomingTraces()) {
            if (!(trace instanceof ComponentExchangeRealization)) continue;
            ret.add((ComponentExchangeRealization)trace);
        }
        return ret;
    }

    protected List<ComponentExchangeRealization> getOutgoingComponentExchangeRealizations(ComponentExchange element) {
        ArrayList<ComponentExchangeRealization> ret = new ArrayList<ComponentExchangeRealization>();
        for (AbstractTrace trace : element.getOutgoingTraces()) {
            if (!(trace instanceof ComponentExchangeRealization)) continue;
            ret.add((ComponentExchangeRealization)trace);
        }
        return ret;
    }

    protected List<FunctionalExchange> getAllocatedFunctionalExchanges(ComponentExchange element) {
        ArrayList<FunctionalExchange> ret = new ArrayList<FunctionalExchange>();
        for (ComponentExchangeFunctionalExchangeAllocation item : element.getOutgoingComponentExchangeFunctionalExchangeAllocations()) {
            FunctionalExchange allocatedFunctionalExchange = item.getAllocatedFunctionalExchange();
            if (allocatedFunctionalExchange == null) continue;
            ret.add(allocatedFunctionalExchange);
        }
        return ret;
    }

    protected List<ComponentExchangeFunctionalExchangeAllocation> getOutgoingComponentExchangeFunctionalExchangeAllocations(ComponentExchange element) {
        ArrayList<ComponentExchangeFunctionalExchangeAllocation> ret = new ArrayList<ComponentExchangeFunctionalExchangeAllocation>();
        for (AbstractTrace trace : element.getOutgoingTraces()) {
            if (!(trace instanceof ComponentExchangeFunctionalExchangeAllocation)) continue;
            ret.add((ComponentExchangeFunctionalExchangeAllocation)trace);
        }
        return ret;
    }

    protected Part getSourcePart(ComponentExchange element) {
        InformationsExchanger source = element.getSource();
        if (source instanceof ComponentExchangeEnd) {
            return ((ComponentExchangeEnd)source).getPart();
        }
        if (source instanceof Part) {
            return (Part)source;
        }
        return null;
    }

    protected Port getSourcePort(ComponentExchange element) {
        InformationsExchanger source = element.getSource();
        if (source instanceof ComponentExchangeEnd) {
            return ((ComponentExchangeEnd)source).getPort();
        }
        if (source instanceof Port) {
            return (Port)source;
        }
        return null;
    }

    protected Part getTargetPart(ComponentExchange element) {
        InformationsExchanger target = element.getTarget();
        if (target instanceof ComponentExchangeEnd) {
            return ((ComponentExchangeEnd)target).getPart();
        }
        if (target instanceof Part) {
            return (Part)target;
        }
        return null;
    }

    protected Port getTargetPort(ComponentExchange element) {
        InformationsExchanger target = element.getTarget();
        if (target instanceof ComponentExchangeEnd) {
            return ((ComponentExchangeEnd)target).getPort();
        }
        if (target instanceof Port) {
            return (Port)target;
        }
        return null;
    }

    protected List<PhysicalLink> getAllocatorPhysicalLinks(ComponentExchange element) {
        ArrayList<PhysicalLink> ret = new ArrayList<PhysicalLink>();
        for (AbstractTrace trace : element.getIncomingTraces()) {
            ComponentExchangeAllocator componentExchangeAllocator;
            if (!(trace instanceof ComponentExchangeAllocation) || !((componentExchangeAllocator = ((ComponentExchangeAllocation)trace).getComponentExchangeAllocator()) instanceof PhysicalLink)) continue;
            ret.add((PhysicalLink)componentExchangeAllocator);
        }
        return ret;
    }

    protected List<ComponentExchange> getRealizedComponentExchanges(ComponentExchange element) {
        ArrayList<ComponentExchange> ret = new ArrayList<ComponentExchange>();
        for (AbstractTrace trace : element.getOutgoingTraces()) {
            ComponentExchange allocatedComponentExchange;
            if (!(trace instanceof ComponentExchangeRealization) || (allocatedComponentExchange = ((ComponentExchangeRealization)trace).getAllocatedComponentExchange()) == null) continue;
            ret.add(allocatedComponentExchange);
        }
        return ret;
    }

    protected List<ComponentExchange> getRealizingComponentExchanges(ComponentExchange element) {
        ArrayList<ComponentExchange> ret = new ArrayList<ComponentExchange>();
        for (AbstractTrace trace : element.getIncomingTraces()) {
            ComponentExchange allocatingComponentExchange;
            if (!(trace instanceof ComponentExchangeRealization) || (allocatingComponentExchange = ((ComponentExchangeRealization)trace).getAllocatingComponentExchange()) == null) continue;
            ret.add(allocatingComponentExchange);
        }
        return ret;
    }
}

