/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.model.label;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class LabelRetriever {
    private static final String BUSINESS_INFORMATION_SOURCE = "http://www.polarsys.org/capella/2007/BusinessInformation";
    private static final String LABEL_KEY = "Label";
    public static final String UNNAMED_ELEMENT = "[Unnamed element]";
    public static final String SEPARATOR = "/";

    public static String getLabel(EObject object) {
        String result = null;
        EStructuralFeature nameAttribute = object.eClass().getEStructuralFeature("name");
        if (nameAttribute != null) {
            result = (String)object.eGet(nameAttribute);
        }
        if (result == null || result.equals("")) {
            result = UNNAMED_ELEMENT;
        }
        if (result == null || result.equals("")) {
            result = object.toString();
        }
        return result;
    }

    public static String getFullLabel(EObject object) {
        String result = String.valueOf(LabelRetriever.getFullPath(object)) + LabelRetriever.getLabel(object);
        return result;
    }

    public static String getFullPath(EObject object) {
        EObject eContainer = object.eContainer();
        if (eContainer == object) {
            return "";
        }
        String result = eContainer != null ? String.valueOf(LabelRetriever.getFullPath(eContainer)) + LabelRetriever.getLabel(eContainer) + SEPARATOR : SEPARATOR;
        return result;
    }

    public static String getLabel(ENamedElement namedElement) {
        String result = null;
        EAnnotation businessAnnotation = namedElement.getEAnnotation(BUSINESS_INFORMATION_SOURCE);
        if (businessAnnotation != null && businessAnnotation.getDetails().containsKey((Object)LABEL_KEY)) {
            result = (String)businessAnnotation.getDetails().get((Object)LABEL_KEY);
        }
        if (result == null || result.equals("")) {
            result = namedElement.getName();
        }
        return result;
    }
}

