/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.core.properties.sections;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.sirius.viewpoint.description.DAnnotation;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.polarsys.capella.core.diagram.helpers.TitleBlockHelper;
import org.polarsys.capella.core.model.utils.NamingHelper;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticField;
import org.polarsys.capella.core.ui.properties.sections.AbstractSection;

public abstract class TitleBlockContainerSection
extends AbstractSection {
    protected Text valueField;

    public void createContents(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage, String textLabel) {
        super.createContents(parent, aTabbedPropertySheetPage);
        this.createTextGroup(parent, textLabel);
    }

    protected void createTextGroup(Composite parent, String label) {
        Composite main = this.getWidgetFactory().createComposite(parent);
        main.setLayout((Layout)new GridLayout(3, false));
        GridData gd = new GridData(768);
        gd.horizontalSpan = ((GridLayout)parent.getLayout()).numColumns;
        main.setLayoutData((Object)gd);
        this.getWidgetFactory().createCLabel(main, label);
        this.valueField = this.getWidgetFactory().createText(main, "");
        this.valueField.setLayoutData((Object)new GridData(768));
    }

    public List<AbstractSemanticField> getSemanticFields() {
        ArrayList<AbstractSemanticField> fields = new ArrayList<AbstractSemanticField>();
        return fields;
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        EObject newEObject = super.setInputSelection(part, selection);
        if (newEObject instanceof DAnnotation && TitleBlockHelper.isTitleBlock((DAnnotation)((DAnnotation)newEObject))) {
            this.loadData(newEObject);
        }
    }

    public void loadData(EObject capellaElement) {
        super.loadData(capellaElement);
        this.setTextGroup(capellaElement);
    }

    protected void setTextGroup(EObject capellaElement) {
        this.valueField.setText(this.getTextGroup(capellaElement));
        this.valueField.setEnabled(false);
        this.valueField.setTouchEnabled(false);
    }

    protected String getTextGroup(EObject capellaElement) {
        String text = "";
        EObject refElement = TitleBlockHelper.getReferencedElement((EObject)capellaElement);
        if (refElement != null) {
            text = NamingHelper.getDefaultTitle((EObject)refElement);
        }
        return text;
    }
}

