/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.search;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.polarsys.capella.core.ui.search.CapellaReplaceHistory;
import org.polarsys.capella.core.ui.search.CapellaSearchSettings;

public class CapellaReplaceDialog
extends Dialog {
    private Combo inputReplacement;
    private final String title;
    private final String pattern;
    private String replacement = "";
    private List<CapellaSearchSettings> previousSearchSettings = new ArrayList<CapellaSearchSettings>();

    public CapellaReplaceDialog(Shell parentShell, String pattern, String title) {
        super(parentShell);
        this.pattern = pattern;
        this.title = title;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Capella Replace");
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        Label titleLabel = new Label(container, 16384);
        titleLabel.setText(this.title);
        titleLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.createInputPattern(container);
        this.createInputReplacement(container);
        return area;
    }

    private void createInputPattern(Composite container) {
        Label label = new Label(container, 0);
        label.setText("Replace");
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        Text inputPattern = new Text(container, 2048);
        inputPattern.setText(this.pattern);
        inputPattern.setLayoutData((Object)gridData);
        inputPattern.setEditable(false);
    }

    private void createInputReplacement(Composite container) {
        String[] previousSearchPatterns;
        this.previousSearchSettings.addAll(CapellaReplaceHistory.getInstance().getAllSearchSettings());
        Label label = new Label(container, 0);
        label.setText("With:");
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.inputReplacement = new Combo(container, 2048);
        this.inputReplacement.setLayoutData((Object)gridData);
        if (!this.previousSearchSettings.isEmpty() && (previousSearchPatterns = (String[])this.previousSearchSettings.stream().filter(x -> x.getReplaceTextPattern() != null).map(CapellaSearchSettings::getReplaceTextPattern).toArray(String[]::new)) != null && previousSearchPatterns.length > 0) {
            this.inputReplacement.setItems(previousSearchPatterns);
            this.inputReplacement.select(0);
        }
        this.inputReplacement.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CapellaSearchSettings previous;
                int selectionIndex = CapellaReplaceDialog.this.inputReplacement.getSelectionIndex();
                if (-1 < selectionIndex && selectionIndex < CapellaReplaceDialog.this.previousSearchSettings.size() && (previous = (CapellaSearchSettings)CapellaReplaceDialog.this.previousSearchSettings.get(selectionIndex)) != null) {
                    CapellaReplaceDialog.this.inputReplacement.setText(previous.getReplaceTextPattern());
                }
            }
        });
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        this.replacement = this.inputReplacement.getText();
        super.okPressed();
    }

    public String getReplacement() {
        return this.replacement;
    }
}

