/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.task;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.helper.task.AbstractCommandTask;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.util.RefreshIdsHolder;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.ArrangeConstraint;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeListElement;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramComponentizationManager;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManager;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManagerRegistry;
import org.eclipse.sirius.diagram.business.internal.metamodel.description.operations.SiriusElementMappingSpecOperations;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.MappingHelper;
import org.eclipse.sirius.diagram.business.internal.sync.DDiagramElementSynchronizer;
import org.eclipse.sirius.diagram.business.internal.sync.DNodeCandidate;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.tool.ContainerCreationDescription;
import org.eclipse.sirius.diagram.description.tool.EdgeCreationDescription;
import org.eclipse.sirius.diagram.description.tool.NodeCreationDescription;
import org.eclipse.sirius.diagram.tools.api.preferences.SiriusDiagramPreferencesKeys;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.sirius.analysis.CapellaServices;
import org.polarsys.capella.core.sirius.analysis.tool.StringUtil;

public class CreateViewTask
extends AbstractCommandTask {
    protected AbstractToolDescription tool;
    protected EObject context;
    protected EObject toCreate;
    protected DSemanticDiagram diagram;
    protected DSemanticDecorator containerView;
    protected String outVariable;

    public CreateViewTask(EObject context, DSemanticDecorator containerView, EObject toCreate, String toolId, String outVariable) {
        this.context = context;
        this.toCreate = toCreate;
        this.containerView = containerView;
        this.diagram = (DSemanticDiagram)CapellaServices.getService().getDiagramContainer((EObject)containerView);
        this.outVariable = outVariable;
        this.tool = this.getTool(toolId);
    }

    private AbstractToolDescription getTool(String toolId) {
        AbstractToolDescription result = null;
        Session session = SessionManager.INSTANCE.getSession(this.diagram.getTarget());
        EList tools = new DiagramComponentizationManager().getAllTools(session.getSelectedViewpoints(false), this.diagram.getDescription());
        for (AbstractToolDescription current : tools) {
            if (!current.getName().equals(toolId)) continue;
            result = current;
        }
        return result;
    }

    public String getLabel() {
        return "create a view";
    }

    protected Collection<EObject> getScope() {
        return Collections.singletonList(this.toCreate);
    }

    protected int computeInheritanceDistance(EObject object, String className) {
        EClass currentEclass = object.eClass();
        if (currentEclass.getName().equals(className)) {
            return 0;
        }
        return this.checkInheritanceDistance(currentEclass, className, -1);
    }

    protected int checkInheritanceDistance(EClass classType, String classSearched, int distanceInheritance) {
        int currentInheritanceDistance = -1;
        for (EClass currentSuperType : classType.getESuperTypes()) {
            if (currentSuperType.getName().equals(classSearched)) {
                return distanceInheritance + 1;
            }
            currentInheritanceDistance = this.checkInheritanceDistance(currentSuperType, classSearched, distanceInheritance + 1);
            if (currentInheritanceDistance == -1) continue;
            return currentInheritanceDistance;
        }
        return -1;
    }

    protected boolean checkBestInheritance(ContainerMapping best, ContainerMapping currentMapping, EObject createdObj, int previousInheritanceDistance) {
        EClass createdObjEClass = createdObj.eClass();
        if (createdObjEClass.getName().equals(this.getDomainClass((DiagramElementMapping)currentMapping))) {
            return true;
        }
        int currentInheritanceDistance = this.computeInheritanceDistance(createdObj, this.getDomainClass((DiagramElementMapping)currentMapping));
        return currentInheritanceDistance != -1 && previousInheritanceDistance > currentInheritanceDistance;
    }

    protected DiagramElementMapping getBestMapping(EObject element, DiagramElementMapping containerMapping) {
        Collection<DiagramElementMapping> validMappings = this.getAllValidMappings(element, containerMapping);
        DiagramElementMapping bestMapping = null;
        int bestIndex = -1;
        for (DiagramElementMapping mapping : validMappings) {
            String domainClass = this.getDomainClass(mapping);
            int current = this.computeInheritanceDistance(element, domainClass);
            if (current == -1 || bestIndex != -1 && bestIndex <= current) continue;
            bestIndex = current;
            bestMapping = mapping;
        }
        return bestMapping;
    }

    protected Collection<DiagramElementMapping> getAllValidMappings(EObject element, DiagramElementMapping containerMapping) {
        HashSet<DiagramElementMapping> validMappings = new HashSet<DiagramElementMapping>();
        DiagramDescription desc = this.diagram.getDescription();
        Session session = SessionManager.INSTANCE.getSession(this.diagram.getTarget());
        if (containerMapping != null) {
            for (DiagramElementMapping mapping : MappingHelper.getAllMappings((DiagramElementMapping)containerMapping)) {
                if (!this.isValidMapping(element, mapping)) continue;
                validMappings.add(mapping);
            }
        }
        for (DiagramElementMapping mapping : new DiagramComponentizationManager().getAllContainerMappings(session.getSelectedViewpoints(false), desc)) {
            if (!this.isValidMapping(element, mapping)) continue;
            validMappings.add(mapping);
        }
        for (DiagramElementMapping mapping : new DiagramComponentizationManager().getAllNodeMappings(session.getSelectedViewpoints(false), desc)) {
            if (!this.isValidMapping(element, mapping)) continue;
            validMappings.add(mapping);
        }
        for (DiagramElementMapping mapping : new DiagramComponentizationManager().getAllEdgeMappings(session.getSelectedViewpoints(false), desc)) {
            if (!this.isValidMapping(element, mapping)) continue;
            validMappings.add(mapping);
        }
        return validMappings;
    }

    protected boolean isValidMapping(EObject element, DiagramElementMapping mapping) {
        if (this.isDomainValid(element, mapping) && SiriusElementMappingSpecOperations.checkPrecondition((DiagramElementMapping)mapping, (EObject)element, (EObject)this.getDestinationContainer().getTarget(), (EObject)this.getDestinationContainer())) {
            Layer layer = (Layer)EcoreUtil2.getFirstContainer((EObject)mapping, (EClass)DescriptionPackage.Literals.LAYER);
            if (layer != null && !this.diagram.getActivatedLayers().contains((Object)layer)) {
                return false;
            }
            if (this.tool != null) {
                if (this.tool instanceof ContainerCreationDescription) {
                    ContainerCreationDescription cTool = (ContainerCreationDescription)this.tool;
                    return cTool.getContainerMappings().contains((Object)mapping);
                }
                if (this.tool instanceof NodeCreationDescription) {
                    NodeCreationDescription cTool = (NodeCreationDescription)this.tool;
                    return cTool.getNodeMappings().contains((Object)mapping);
                }
                if (this.tool instanceof EdgeCreationDescription) {
                    EdgeCreationDescription cTool = (EdgeCreationDescription)this.tool;
                    return cTool.getEdgeMappings().contains((Object)mapping);
                }
            }
            return true;
        }
        return false;
    }

    private boolean isDomainValid(EObject element, DiagramElementMapping mapping) {
        String domainClass = this.getDomainClass(mapping);
        if (domainClass != null) {
            if (domainClass.equals(element.eClass().getName())) {
                return true;
            }
            for (EClass parent : element.eClass().getEAllSuperTypes()) {
                if (!domainClass.equals(parent.getName())) continue;
                return true;
            }
        }
        return false;
    }

    protected String getDomainClass(DiagramElementMapping mapping) {
        String domainClass = null;
        if (mapping instanceof EdgeMapping) {
            domainClass = ((EdgeMapping)mapping).getDomainClass();
        } else if (mapping instanceof AbstractNodeMapping) {
            domainClass = ((AbstractNodeMapping)mapping).getDomainClass();
        }
        return StringUtil.lastSegment(domainClass, Arrays.asList(".", "::"));
    }

    public void execute() {
        DSemanticDecorator destinationContainer = this.getDestinationContainer();
        DiagramElementMapping containerMapping = this.getViewMapping(destinationContainer);
        for (EObject element : this.getScope()) {
            DiagramElementMapping mapping = this.getBestMapping(element, containerMapping);
            if (mapping == null) continue;
            DDiagramElement view = this.createNode(element, mapping, (DragAndDropTarget)destinationContainer);
            InterpreterUtil.getInterpreter((EObject)element).setVariable(this.outVariable, (Object)view);
        }
    }

    private DDiagramElement createNode(EObject element, DiagramElementMapping mapping, DragAndDropTarget containerView) {
        AbstractDNode newView = null;
        RefreshIdsHolder refreshId = RefreshIdsHolder.getOrCreateHolder((EObject)this.diagram);
        ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor((EObject)this.diagram);
        DNodeCandidate candidate = new DNodeCandidate((AbstractNodeMapping)mapping, element, containerView, refreshId);
        DDiagramElementSynchronizer sync = new DDiagramElementSynchronizer(this.diagram, InterpreterUtil.getInterpreter((EObject)element), accessor){

            public void refresh(DDiagramElement newNode) {
                if (newNode instanceof DNode) {
                    this.refresh((DNode)newNode);
                } else if (newNode instanceof DNodeListElement) {
                    this.refresh((DNodeListElement)newNode);
                } else if (newNode instanceof DDiagramElementContainer) {
                    this.refresh((DDiagramElementContainer)newNode);
                } else if (newNode instanceof DEdge) {
                    this.refresh((DEdge)newNode);
                }
            }
        };
        Session session = SessionManager.INSTANCE.getSession(element);
        DiagramMappingsManager mappingManager = DiagramMappingsManagerRegistry.INSTANCE.getDiagramMappingsManager(session, (DDiagram)this.diagram);
        newView = sync.createNewNode(mappingManager, candidate, false);
        this.initView((DDiagramElement)newView);
        return newView;
    }

    protected boolean autoPinOnCreateEnabled() {
        return Platform.getPreferencesService().getBoolean("org.eclipse.sirius", SiriusDiagramPreferencesKeys.PREF_AUTO_PIN_ON_CREATE.name(), true, new IScopeContext[0]);
    }

    protected void initView(DDiagramElement newView) {
        if (newView instanceof DDiagramElementContainer) {
            DDiagramElementContainer container = (DDiagramElementContainer)newView;
            if (this.autoPinOnCreateEnabled()) {
                container.getArrangeConstraints().add((Object)ArrangeConstraint.KEEP_LOCATION);
                container.getArrangeConstraints().add((Object)ArrangeConstraint.KEEP_RATIO);
                container.getArrangeConstraints().add((Object)ArrangeConstraint.KEEP_SIZE);
            }
        }
    }

    protected DSemanticDecorator getDestinationContainer() {
        return this.containerView;
    }

    private DiagramElementMapping getViewMapping(DSemanticDecorator element) {
        DiagramElementMapping result = null;
        if (element != null) {
            if (element instanceof DDiagramElementContainer) {
                result = ((DDiagramElementContainer)element).getDiagramElementMapping();
            } else if (element instanceof DNode) {
                result = ((DNode)element).getActualMapping();
            } else if (element instanceof DEdge) {
                result = ((DEdge)element).getDiagramElementMapping();
            }
        }
        return result;
    }
}

