/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.showhide;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.tools.api.ui.ExternalJavaActionProvider;
import org.eclipse.sirius.tools.api.ui.IExternalJavaAction;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.sirius.analysis.CapellaServices;
import org.polarsys.capella.core.sirius.analysis.ContextServices;
import org.polarsys.capella.core.sirius.analysis.DDiagramContents;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.actions.extensions.SelectElementsFromTransferWizard;
import org.polarsys.capella.core.sirius.analysis.showhide.AbstractShowHide;
import org.polarsys.capella.core.sirius.analysis.showhide.Messages;
import org.polarsys.capella.core.sirius.analysis.showhide.ShowHideFactory;

public class ShowHideService {
    protected static final String CONTEXT = "context";
    protected static final String SCOPE = "scope";
    protected static final String WIZARD_MESSAGE = "wizardMessage";
    protected static final String WIZARD_TITLE = "wizardTitle";
    protected static final String RESULT_VARIABLE = "resultVariable";
    protected static final String INITIAL_SELECTION = "initialSelection";
    protected static final String SEMANTIC_CANDIDATE = "semanticCandidate";
    private static ShowHideService singleton = null;

    public static ShowHideService getService() {
        if (singleton == null) {
            singleton = new ShowHideService();
        }
        return singleton;
    }

    @Deprecated
    public DSemanticDecorator applyShowHide(DSemanticDecorator view, List<EObject> selectedElements, List<EObject> visibleElments, List<DDiagramElement> visibleElementViews, AbstractShowHide showHideHandler) {
        return this.applyShowHide(view, selectedElements, visibleElementViews, showHideHandler);
    }

    public DSemanticDecorator applyShowHide(DSemanticDecorator view, List<EObject> selectedElements, Iterable<DDiagramElement> visibleElementViews, AbstractShowHide showHideHandler) {
        AbstractShowHide.DiagramContext diagramContext = new AbstractShowHide.DiagramContext(showHideHandler);
        for (EObject eObj : selectedElements) {
            showHideHandler.show(eObj, diagramContext);
        }
        HashSet<EObject> toBeRemoved = new HashSet<EObject>();
        for (DDiagramElement node : visibleElementViews) {
            if (selectedElements.contains(node.getTarget())) continue;
            toBeRemoved.add(node.getTarget());
        }
        for (EObject aView : toBeRemoved) {
            showHideHandler.hide(aView, diagramContext);
        }
        return view;
    }

    public void genericSelectElements(DSemanticDecorator view) {
        String eClassName = (String)InterpreterUtil.getInterpreter((EObject)view).getVariable(SEMANTIC_CANDIDATE);
        EClass eClass = this.getEClassFromName(eClassName);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(CONTEXT, view);
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)view);
        DDiagramContents content = new DDiagramContents(diagram);
        DiagramElementMapping mapping = ShowHideService.getService().getMapping(eClass, diagram);
        List<Object> scope = this.getShowHideAvailableElements(diagram, view, eClass);
        if (scope == null) {
            scope = Collections.emptyList();
        }
        parameters.put(SCOPE, scope);
        parameters.put(WIZARD_MESSAGE, Messages.ShowHideService_Select_element_wizard_message);
        Collection<EObject> initialSelection = content.asSemantic(content.getDiagramElements(view, mapping));
        initialSelection.retainAll(scope);
        parameters.put(INITIAL_SELECTION, initialSelection);
        parameters.put(RESULT_VARIABLE, RESULT_VARIABLE);
        IExternalJavaAction action = ExternalJavaActionProvider.INSTANCE.getJavaActionById(this.getJavaActionId());
        action.execute(null, parameters);
    }

    protected String getJavaActionId() {
        return SelectElementsFromTransferWizard.class.getName();
    }

    public void genericShowHideElements(DSemanticDecorator view) {
        List<Object> selectedElements = null;
        Object variable = InterpreterUtil.getInterpreter((EObject)view).getVariable(RESULT_VARIABLE);
        selectedElements = variable instanceof Object[] ? Arrays.asList((Object[])variable) : (List<Object>)variable;
        if (selectedElements == null) {
            selectedElements = new ArrayList<Object>();
        }
        String eClassName = (String)InterpreterUtil.getInterpreter((EObject)view).getVariable(SEMANTIC_CANDIDATE);
        EClass eClass = this.getEClassFromName(eClassName);
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)view);
        DDiagramContents content = new DDiagramContents(diagram);
        DiagramElementMapping mapping = ShowHideService.getService().getMapping(eClass, diagram);
        AbstractShowHide shHide = ShowHideFactory.createShowHide(eClass, view.getTarget(), content);
        ShowHideService.getService().applyShowHide(view, selectedElements, content.getDiagramElements(view, mapping), shHide);
    }

    private EClass getEClassFromName(String eClass) {
        if (InteractionPackage.Literals.ABSTRACT_CAPABILITY.getName().equals(eClass)) {
            return InteractionPackage.Literals.ABSTRACT_CAPABILITY;
        }
        if (LaPackage.Literals.CAPABILITY_REALIZATION.getName().equals(eClass)) {
            return LaPackage.Literals.CAPABILITY_REALIZATION;
        }
        if (CtxPackage.Literals.MISSION.getName().equals(eClass)) {
            return CtxPackage.Literals.MISSION;
        }
        if (OaPackage.Literals.ENTITY.getName().equals(eClass)) {
            return OaPackage.Literals.ENTITY;
        }
        if (CsPackage.Literals.COMPONENT.getName().equals(eClass)) {
            return CsPackage.Literals.COMPONENT;
        }
        return null;
    }

    public DiagramElementMapping getMapping(EClass eClass, DDiagram diagram) {
        if ("Missions Capabilities Blank".equals(diagram.getDescription().getName())) {
            if (InteractionPackage.Literals.ABSTRACT_CAPABILITY.isSuperTypeOf(eClass)) {
                return DiagramServices.getDiagramServices().getNodeMapping(diagram, "CapabilityNode4");
            }
            if (CtxPackage.Literals.MISSION.isSuperTypeOf(eClass)) {
                return DiagramServices.getDiagramServices().getNodeMapping(diagram, "MissionNode4");
            }
        } else if ("Missions Blank".equals(diagram.getDescription().getName())) {
            if (InteractionPackage.Literals.ABSTRACT_CAPABILITY.isSuperTypeOf(eClass)) {
                return DiagramServices.getDiagramServices().getNodeMapping(diagram, "CapNode2");
            }
            if (CtxPackage.Literals.MISSION.isSuperTypeOf(eClass)) {
                return DiagramServices.getDiagramServices().getNodeMapping(diagram, "MissionNode2");
            }
        } else if ("Contextual Capability".equals(diagram.getDescription().getName())) {
            if (InteractionPackage.Literals.ABSTRACT_CAPABILITY.isSuperTypeOf(eClass)) {
                return DiagramServices.getDiagramServices().getNodeMapping(diagram, "Capability3");
            }
            if (CtxPackage.Literals.MISSION.isSuperTypeOf(eClass)) {
                return DiagramServices.getDiagramServices().getNodeMapping(diagram, "MissionNode3");
            }
        } else if ("Contextual Mission".equals(diagram.getDescription().getName())) {
            if (InteractionPackage.Literals.ABSTRACT_CAPABILITY.isSuperTypeOf(eClass)) {
                return DiagramServices.getDiagramServices().getNodeMapping(diagram, "CapNode");
            }
        } else if ("Contextual Operational Capability".equals(diagram.getDescription().getName())) {
            if (InteractionPackage.Literals.ABSTRACT_CAPABILITY.isSuperTypeOf(eClass)) {
                return DiagramServices.getDiagramServices().getNodeMapping(diagram, "COC2_OperationalCapabilities");
            }
            if (OaPackage.Literals.ENTITY.isSuperTypeOf(eClass)) {
                return DiagramServices.getDiagramServices().getContainerMapping(diagram, "COC2_Entities");
            }
        } else if ("Operational Capabilities Blank".equals(diagram.getDescription().getName())) {
            if (InteractionPackage.Literals.ABSTRACT_CAPABILITY.isSuperTypeOf(eClass)) {
                return DiagramServices.getDiagramServices().getNodeMapping(diagram, "COC_OperationalCapabilities");
            }
            if (OaPackage.Literals.ENTITY.isSuperTypeOf(eClass)) {
                return DiagramServices.getDiagramServices().getContainerMapping(diagram, "COC_OperationalEntities");
            }
        } else if ("Capability Realization Blank".equals(diagram.getDescription().getName())) {
            if (InteractionPackage.Literals.ABSTRACT_CAPABILITY.isSuperTypeOf(eClass)) {
                return DiagramServices.getDiagramServices().getNodeMapping(diagram, "CRB CapabilityRealization");
            }
            if (CsPackage.Literals.COMPONENT.isSuperTypeOf(eClass)) {
                return DiagramServices.getDiagramServices().getContainerMapping(diagram, "CRB Component");
            }
        } else if ("Contextual Capability Realization Involvement".equals(diagram.getDescription().getName())) {
            if (CsPackage.Literals.COMPONENT.isSuperTypeOf(eClass)) {
                return DiagramServices.getDiagramServices().getNodeMapping(diagram, "CCRI Component");
            }
            if (LaPackage.Literals.CAPABILITY_REALIZATION.isSuperTypeOf(eClass)) {
                return DiagramServices.getDiagramServices().getNodeMapping(diagram, "CCRI CapabilityRealization");
            }
        }
        return null;
    }

    protected List<EObject> getShowHideAvailableElements(DDiagram diagram, DSemanticDecorator view, EClass type) {
        if ("Missions Capabilities Blank".equals(diagram.getDescription().getName())) {
            if (InteractionPackage.Literals.ABSTRACT_CAPABILITY.equals(type)) {
                return ContextServices.getServices().getMCBCapabilities((DSemanticDecorator)diagram);
            }
            if (CtxPackage.Literals.MISSION.equals(type)) {
                return ContextServices.getServices().getMCBMissions((DSemanticDecorator)diagram);
            }
        } else if ("Missions Blank".equals(diagram.getDescription().getName())) {
            if (InteractionPackage.Literals.ABSTRACT_CAPABILITY.equals(type)) {
                return ContextServices.getServices().getMBCapabilities((DSemanticDecorator)diagram);
            }
            if (CtxPackage.Literals.MISSION.equals(type)) {
                return ContextServices.getServices().getMBMissions((DSemanticDecorator)diagram);
            }
        } else if ("Contextual Capability".equals(diagram.getDescription().getName())) {
            if (InteractionPackage.Literals.ABSTRACT_CAPABILITY.equals(type)) {
                return ContextServices.getServices().getCCCapabilities((DSemanticDecorator)diagram);
            }
            if (CtxPackage.Literals.MISSION.equals(type)) {
                return ContextServices.getServices().getCCMissions((DSemanticDecorator)diagram);
            }
        } else if ("Contextual Mission".equals(diagram.getDescription().getName())) {
            if (InteractionPackage.Literals.ABSTRACT_CAPABILITY.equals(type)) {
                return ContextServices.getServices().getCMCapabilities((DSemanticDecorator)diagram);
            }
        } else if ("Contextual Operational Capability".equals(diagram.getDescription().getName())) {
            if (InteractionPackage.Literals.ABSTRACT_CAPABILITY.equals(type)) {
                return ContextServices.getServices().getCOCCapabilities((DSemanticDecorator)diagram);
            }
            if (OaPackage.Literals.ENTITY.equals(type)) {
                return ContextServices.getServices().getCOCEntities(view);
            }
        } else if ("Operational Capabilities Blank".equals(diagram.getDescription().getName())) {
            if (InteractionPackage.Literals.ABSTRACT_CAPABILITY.equals(type)) {
                return ContextServices.getServices().getOCBCapabilities((DSemanticDecorator)diagram);
            }
            if (OaPackage.Literals.ENTITY.equals(type)) {
                return ContextServices.getServices().getOCBEntities(view);
            }
        } else if ("Capability Realization Blank".equals(diagram.getDescription().getName())) {
            if (InteractionPackage.Literals.ABSTRACT_CAPABILITY.equals(type)) {
                return ContextServices.getServices().getCRBCapabilities((DSemanticDecorator)diagram);
            }
            if (CsPackage.Literals.COMPONENT.equals(type)) {
                return new ArrayList<Component>(ContextServices.getServices().getCRBComponents(view));
            }
        } else if ("Contextual Capability Realization Involvement".equals(diagram.getDescription().getName())) {
            if (CsPackage.Literals.COMPONENT.equals(type)) {
                return ContextServices.getServices().getCRIComponents(view);
            }
            if (LaPackage.Literals.CAPABILITY_REALIZATION.equals(type)) {
                return ContextServices.getServices().getCRICapabilityRealizations(view);
            }
        }
        return null;
    }

    @Deprecated
    public Collection<DDiagramElement> getAllDisplayedViewsForMapping(DSemanticDecorator diagramElt, DiagramElementMapping mapping) {
        return this.getAllDisplayedViewsForMappings(diagramElt, Arrays.asList(mapping));
    }

    @Deprecated
    public Collection<DDiagramElement> getAllDisplayedViewsForMappings(DSemanticDecorator diagramElt, List<DiagramElementMapping> mappings) {
        ArrayList<DDiagramElement> diagElements = new ArrayList<DDiagramElement>();
        if (diagramElt instanceof DDiagram) {
            DDiagram diagram = (DDiagram)diagramElt;
            DDiagramContents diagContents = new DDiagramContents(diagram);
            for (DiagramElementMapping mapping : mappings) {
                for (DDiagramElement element : diagContents.getDiagramElements(mapping)) {
                    diagElements.add(element);
                }
            }
        }
        return diagElements;
    }

    @Deprecated
    public Collection<EObject> getAllDisplayedElementsForMapping(DSemanticDecorator diagramElt, DiagramElementMapping mapping) {
        return this.getAllDisplayedElementsForMappings(diagramElt, Arrays.asList(mapping));
    }

    @Deprecated
    public Collection<EObject> getAllDisplayedElementsForMappings(DSemanticDecorator diagramElt, List<DiagramElementMapping> mappings) {
        ArrayList<EObject> diagElements = new ArrayList<EObject>();
        for (DDiagramElement diagElt : this.getAllDisplayedViewsForMappings(diagramElt, mappings)) {
            diagElements.add(diagElt.getTarget());
        }
        return diagElements;
    }
}

