/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.cache;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.helpers.cache.Cache;
import org.polarsys.capella.core.data.interaction.AbstractEnd;
import org.polarsys.capella.core.data.interaction.AbstractFragment;
import org.polarsys.capella.core.data.interaction.Execution;
import org.polarsys.capella.core.data.interaction.ExecutionEnd;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.InteractionFragment;
import org.polarsys.capella.core.data.interaction.InteractionState;
import org.polarsys.capella.core.data.interaction.MessageEnd;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.data.interaction.StateFragment;
import org.polarsys.capella.core.data.interaction.TimeLapse;
import org.polarsys.capella.core.sirius.analysis.SequenceDiagramServices;

public class ScenarioCache {
    private static ScenarioCache instance;
    private Cache interactionCache = new Cache();
    private Map<InteractionFragment, TimeLapse> interactionFragmentToTimeLapseCache = new ConcurrentHashMap<InteractionFragment, TimeLapse>();
    private Map<EObject, Collection<EObject>> semanticCandidatesCache = new ConcurrentHashMap<EObject, Collection<EObject>>();
    private Map<InstanceRole, List<SemanticCandidateContext>> instanceRoleToSemanticCandidateContextsCache = new ConcurrentHashMap<InstanceRole, List<SemanticCandidateContext>>();
    private boolean isCacheEnabled;

    private ScenarioCache() {
    }

    public static ScenarioCache getInstance() {
        if (instance == null) {
            instance = new ScenarioCache();
        }
        return instance;
    }

    public void clearCaches() {
        this.interactionCache.clearCache();
        this.semanticCandidatesCache.clear();
        this.instanceRoleToSemanticCandidateContextsCache.clear();
        this.interactionFragmentToTimeLapseCache.clear();
    }

    public <P, R> R getInteractionCache(Function<P, R> function, P parameter) {
        return (R)this.interactionCache.get(function, parameter);
    }

    public List<SemanticCandidateContext> getInstanceRoleToSemanticCandidateContextCache(InstanceRole instanceRole) {
        return this.instanceRoleToSemanticCandidateContextsCache.get(instanceRole);
    }

    public void putInstanceRoleToSemanticCandidateContextsCache(InstanceRole instanceRole, List<SemanticCandidateContext> structure) {
        this.instanceRoleToSemanticCandidateContextsCache.put(instanceRole, structure);
    }

    public Collection<EObject> getSemanticCandidatesFromCache(EObject capellaElement) {
        return this.semanticCandidatesCache.get(capellaElement);
    }

    public void putSemanticCandidatesInCache(EObject element, Collection<EObject> container) {
        this.semanticCandidatesCache.put(element, container);
    }

    public TimeLapse getTimeLapseFromCache(InteractionFragment key) {
        return this.interactionFragmentToTimeLapseCache.get(key);
    }

    public void putTimeLapseInCache(InteractionFragment key, TimeLapse value) {
        this.interactionFragmentToTimeLapseCache.put(key, value);
    }

    public Map<InteractionFragment, TimeLapse> getInteractionFragmentToTimeLapseCache() {
        return this.interactionFragmentToTimeLapseCache;
    }

    public boolean isRefreshCacheEnabled() {
        return this.isCacheEnabled;
    }

    public void enableRefreshCache() {
        this.isCacheEnabled = true;
    }

    public void disableRefreshCache() {
        this.isCacheEnabled = false;
    }

    public List<SemanticCandidateContext> getSemanticCandidateContexts(InstanceRole instanceRole) {
        List<SemanticCandidateContext> semanticCandidateContexts = this.getInstanceRoleToSemanticCandidateContextCache(instanceRole);
        if (semanticCandidateContexts == null) {
            semanticCandidateContexts = this.computeInstanceRoleSemanticCandidateContextStructure(instanceRole);
            if (this.isRefreshCacheEnabled()) {
                this.putInstanceRoleToSemanticCandidateContextsCache(instanceRole, semanticCandidateContexts);
            }
        }
        return semanticCandidateContexts;
    }

    private Collection<EObject> getSemanticCandidates(InstanceRole instanceRole, EObject element) {
        Collection semanticCandidates = this.getSemanticCandidatesFromCache(element);
        if (semanticCandidates == null) {
            List<SemanticCandidateContext> semanticCandidateContexts = this.getSemanticCandidateContexts(instanceRole);
            semanticCandidates = semanticCandidateContexts.stream().filter(scc -> element.equals(scc.getParent())).map(SemanticCandidateContext::getElement).filter(candidate -> candidate != element).distinct().collect(Collectors.toList());
            if (this.isRefreshCacheEnabled()) {
                this.putSemanticCandidatesInCache(element, semanticCandidates);
            }
        }
        return semanticCandidates;
    }

    public Collection<Execution> getExecutionSemanticCandidates(InstanceRole instanceRole, EObject element) {
        return this.getSemanticCandidates(instanceRole, element).stream().filter(Execution.class::isInstance).map(Execution.class::cast).collect(Collectors.toList());
    }

    public List<StateFragment> getStateFragmentSemanticCandidates(InstanceRole instanceRole, EObject element) {
        return this.getSemanticCandidates(instanceRole, element).stream().filter(StateFragment.class::isInstance).map(StateFragment.class::cast).collect(Collectors.toList());
    }

    private List<SemanticCandidateContext> computeInstanceRoleSemanticCandidateContextStructure(InstanceRole instanceRole) {
        if (instanceRole == null || !(instanceRole.eContainer() instanceof Scenario)) {
            return Collections.emptyList();
        }
        Scenario scenario = SequenceDiagramServices.getScenario((EObject)instanceRole);
        ArrayDeque<InstanceRole> ancestors = new ArrayDeque<InstanceRole>();
        ancestors.push(instanceRole);
        ArrayList<SemanticCandidateContext> result = new ArrayList<SemanticCandidateContext>();
        this.computeTimeLapseStartAndEndCache(scenario);
        Stream<InteractionFragment> interactionFragments = scenario.getOwnedInteractionFragments().stream().filter(frag -> frag instanceof AbstractEnd || frag instanceof InteractionState);
        interactionFragments.forEachOrdered(end -> {
            InstanceRole coveredInstanceRole = this.getCoveredInstanceRole((InteractionFragment)end);
            if (coveredInstanceRole != null && coveredInstanceRole.equals(instanceRole)) {
                TimeLapse timeLapse = this.getTimeLapseFromCache((InteractionFragment)end);
                if (end instanceof ExecutionEnd) {
                    this.visit((Deque<CapellaElement>)ancestors, timeLapse, (ExecutionEnd)end, (List<SemanticCandidateContext>)result);
                }
                if (end instanceof InteractionState) {
                    this.visit((Deque<CapellaElement>)ancestors, timeLapse, (InteractionState)end, (List<SemanticCandidateContext>)result);
                }
                if (end instanceof MessageEnd) {
                    this.visit((Deque<CapellaElement>)ancestors, timeLapse, (MessageEnd)end, (List<SemanticCandidateContext>)result);
                }
            }
        });
        return result;
    }

    private void visit(Deque<CapellaElement> ancestors, TimeLapse timeLapse, MessageEnd end, List<SemanticCandidateContext> result) {
        SequenceMessage message;
        if (timeLapse instanceof Execution && ((Execution)timeLapse).getStart() == end) {
            result.add(new SemanticCandidateContext((EObject)ancestors.peek(), (EObject)timeLapse, true, ancestors.size() + 1));
            ancestors.push((CapellaElement)timeLapse);
        }
        if ((message = end.getMessage()) != null) {
            result.add(new SemanticCandidateContext((EObject)ancestors.peek(), (EObject)message, end.equals(message.getSendingEnd()), ancestors.size()));
        }
        if (timeLapse instanceof Execution && ((Execution)timeLapse).getFinish() == end) {
            ancestors.pop();
            result.add(new SemanticCandidateContext((EObject)ancestors.peek(), (EObject)timeLapse, false, ancestors.size() + 1));
        }
    }

    private void visit(Deque<CapellaElement> ancestors, TimeLapse timeLapse, InteractionState end, List<SemanticCandidateContext> result) {
        if (timeLapse instanceof StateFragment && ((StateFragment)timeLapse).getStart() == end) {
            result.add(new SemanticCandidateContext((EObject)ancestors.peek(), (EObject)timeLapse, true, ancestors.size() + 1));
        }
        if (timeLapse instanceof StateFragment && ((StateFragment)timeLapse).getFinish() == end) {
            result.add(new SemanticCandidateContext((EObject)ancestors.peek(), (EObject)timeLapse, false, ancestors.size() + 1));
        }
    }

    private void visit(Deque<CapellaElement> ancestors, TimeLapse timeLapse, ExecutionEnd end, List<SemanticCandidateContext> result) {
        if (timeLapse != null && timeLapse.getStart() == end) {
            result.add(new SemanticCandidateContext((EObject)ancestors.peek(), (EObject)timeLapse, true, ancestors.size() + 1));
            ancestors.push((CapellaElement)timeLapse);
        }
        if (timeLapse != null && timeLapse.getFinish() == end) {
            ancestors.pop();
            result.add(new SemanticCandidateContext((EObject)ancestors.peek(), (EObject)timeLapse, false, ancestors.size() + 1));
        }
    }

    private InstanceRole getCoveredInstanceRole(InteractionFragment end) {
        InstanceRole covered = null;
        if (end instanceof AbstractEnd) {
            covered = this.getInteractionCache(AbstractEnd::getCovered, (AbstractEnd)end);
        } else if (end instanceof InteractionState) {
            covered = this.getInteractionCache(InteractionState::getCovered, (InteractionState)end);
        }
        return covered;
    }

    private void computeTimeLapseStartAndEndCache(Scenario scenario) {
        if (this.getInteractionFragmentToTimeLapseCache().isEmpty()) {
            Stream<TimeLapse> timeLapses = scenario.getOwnedTimeLapses().stream().filter(tl -> !(tl instanceof AbstractFragment));
            timeLapses.forEach(e -> {
                this.putTimeLapseInCache(e.getStart(), (TimeLapse)e);
                this.putTimeLapseInCache(e.getFinish(), (TimeLapse)e);
            });
        }
    }

    public static final class SemanticCandidateContext {
        private final EObject parent;
        private final boolean start;
        private final EObject element;
        private final int level;

        public SemanticCandidateContext(EObject parent, EObject element, boolean start, int level) {
            this.parent = parent;
            this.element = element;
            this.level = level;
            this.start = start;
        }

        public boolean isStart() {
            return this.start;
        }

        public EObject getParent() {
            return this.parent;
        }

        public EObject getElement() {
            return this.element;
        }

        public int getLevel() {
            return this.level;
        }

        public String toString() {
            return String.format("%02d\t%s\t%s", this.getLevel(), this.element, this.parent);
        }
    }
}

