/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.common.ui.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeColumn;

public class CSVExporter {
    private static final Logger logger = Logger.getLogger(CSVExporter.class.getName());
    private static final String[] FILTER_NAMES = new String[]{"Comma Separated Values Files (*.csv)", "All Files (*.*)"};
    private static final String[] FILTER_EXTS = new String[]{"*.csv", "*.*"};
    private PrintWriter resultFile;
    private TreeViewer diffviewer;

    public CSVExporter(Shell shell, TreeViewer diffviewer) {
        FileDialog fileDialog = new FileDialog(shell, 8192);
        fileDialog.setFilterNames(FILTER_NAMES);
        fileDialog.setFilterExtensions(FILTER_EXTS);
        fileDialog.setText("Choose file to save the differences");
        fileDialog.setFileName("DifferencesLog");
        String myResultFile = fileDialog.open();
        this.diffviewer = diffviewer;
        if (myResultFile != null) {
            this.createFile(myResultFile);
            this.exportFromViewer();
        }
    }

    private void exportFromViewer() {
        int nbColumn = this.diffviewer.getTree().getColumnCount();
        TreeColumn[] treeColumnArray = this.diffviewer.getTree().getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn treeColumn = treeColumnArray[n2];
            if (treeColumn.getWidth() != 0) {
                this.writeField(treeColumn.getText());
            }
            ++n2;
        }
        this.writeNewLine();
        int i = 0;
        while (i < this.diffviewer.getTree().getItemCount()) {
            int j = 0;
            while (j < nbColumn) {
                TreeColumn treeColumn = this.diffviewer.getTree().getColumns()[j];
                if (treeColumn.getWidth() != 0) {
                    String string = this.diffviewer.getTree().getItem(i).getText(j);
                    this.writeField(string);
                }
                ++j;
            }
            this.writeNewLine();
            ++i;
        }
        this.resultFile.close();
    }

    private void createFile(String resultCVSFile) {
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (FileWriter csvFileWriter = new FileWriter(resultCVSFile);){
                File errorFile = new File(resultCVSFile);
                if (errorFile.exists()) {
                    errorFile.delete();
                }
                this.resultFile = new PrintWriter(new BufferedWriter(csvFileWriter));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            MessageBox lMessageBox = new MessageBox(new Shell(), 32);
            lMessageBox.setText("Write EXCEL file");
            lMessageBox.setMessage("Write operation failed \n" + e.getMessage());
            lMessageBox.open();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void writeField(String pField) {
        String dotComma = ";";
        if (pField == null) {
            this.resultFile.print("");
        } else {
            this.resultFile.print(pField);
        }
        this.resultFile.print(dotComma);
    }

    public void writeNewLine() {
        this.resultFile.println();
    }
}

