/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.fa.validation.connection;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.model.helpers.ComponentExchangeExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.PortExt;
import org.polarsys.capella.core.model.helpers.RefinementLinkExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class CN01_Connection_RealizingBound
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof ComponentExchange) {
            ComponentExchange exch = (ComponentExchange)eObj;
            List previousPhaseElements = RefinementLinkExt.getRelatedTargetElements((CapellaElement)((CapellaElement)eObj), (EClass)FaPackage.Literals.COMPONENT_EXCHANGE);
            for (CapellaElement element : previousPhaseElements) {
                ComponentExchange exc = (ComponentExchange)element;
                if (!this.isValid(exc, exch)) continue;
                return ctx.createSuccessStatus();
            }
            if (previousPhaseElements.size() != 0) {
                return this.createFailureStatus(ctx, new Object[]{exch.getName()});
            }
        }
        return ctx.createSuccessStatus();
    }

    private boolean isValid(ComponentExchange previous, ComponentExchange current) {
        Port sourcePrevious = ComponentExchangeExt.getSourcePort((ComponentExchange)previous);
        Port sourceCurrent = ComponentExchangeExt.getSourcePort((ComponentExchange)current);
        Component sourceComponentPrevious = ComponentExchangeExt.getSourceComponent((ComponentExchange)previous);
        if (ComponentExchangeExt.getSourcePart((ComponentExchange)previous) != null) {
            sourceComponentPrevious = null;
        }
        Component sourceComponentCurrent = ComponentExchangeExt.getSourceComponent((ComponentExchange)current);
        if (ComponentExchangeExt.getSourcePart((ComponentExchange)current) != null) {
            sourceComponentCurrent = null;
        }
        Port targetPrevious = ComponentExchangeExt.getTargetPort((ComponentExchange)previous);
        Port targetCurrent = ComponentExchangeExt.getTargetPort((ComponentExchange)current);
        Component targetComponentPrevious = ComponentExchangeExt.getTargetComponent((ComponentExchange)previous);
        if (ComponentExchangeExt.getTargetPart((ComponentExchange)previous) != null) {
            targetComponentPrevious = null;
        }
        Component targetComponentCurrent = ComponentExchangeExt.getTargetComponent((ComponentExchange)current);
        if (ComponentExchangeExt.getTargetPart((ComponentExchange)current) != null) {
            targetComponentCurrent = null;
        }
        boolean sourceValid = this.isValid(sourcePrevious, sourceCurrent, sourceComponentPrevious, sourceComponentCurrent);
        boolean targetValid = this.isValid(targetPrevious, targetCurrent, targetComponentPrevious, targetComponentCurrent);
        return sourceValid && targetValid;
    }

    private boolean isValid(Port portPrevious, Port portCurrent, Component parentPrevious, Component parentCurrent) {
        boolean sourceValid = true;
        if (portPrevious != null && portCurrent != null) {
            if (portPrevious instanceof ComponentPort && portCurrent instanceof ComponentPort) {
                sourceValid = PortExt.isTransitionedTo((ComponentPort)((ComponentPort)portPrevious), (ComponentPort)((ComponentPort)portCurrent));
            }
        } else if (portCurrent != null && parentPrevious != null && parentCurrent != null) {
            Collection parentsPrevious = ComponentExt.getAllSubUsedComponents((Component)parentPrevious);
            parentsPrevious.addAll(ComponentExt.getComponentAncestors((Component)parentPrevious));
            parentsPrevious.add(parentPrevious);
            sourceValid = false;
            for (Component previous : parentsPrevious) {
                if (!RefinementLinkExt.isLinkedTo((TraceableElement)parentCurrent, (TraceableElement)previous)) continue;
                sourceValid = true;
            }
        }
        return sourceValid;
    }
}

