/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.actions;

import java.util.Collection;
import java.util.stream.Collectors;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.platform.sirius.ui.commands.DeleteRepresentationCommand;
import org.polarsys.capella.core.sirius.ui.Messages;

public class DeleteRepresentationAction
extends BaseSelectionListenerAction {
    public DeleteRepresentationAction() {
        super("Delete");
        this.setActionDefinitionId("org.eclipse.ui.edit.delete");
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
    }

    public void run() {
        IStructuredSelection selection = this.getStructuredSelection();
        Collection selectedRepresentations = RepresentationHelper.getSelectedDescriptors((Collection)selection.toList());
        if (!selectedRepresentations.isEmpty()) {
            TransactionalEditingDomain domain;
            int deletedDiagramCount = selectedRepresentations.size();
            String contextualMessage = null;
            String name = String.join((CharSequence)", ", selectedRepresentations.stream().map(d -> d.getName()).collect(Collectors.toList()));
            contextualMessage = deletedDiagramCount == 1 ? NLS.bind((String)Messages.DeleteRepresentationAction_One_Diagram_Message, (Object)name) : NLS.bind((String)Messages.DeleteRepresentationAction_Multiple_Diagram_Message, (Object)name);
            if (MessageDialog.openConfirm(null, (String)Messages.DeleteRepresentationAction_Title, (String)(String.valueOf(Messages.DeleteRepresentationAction_Message) + contextualMessage)) && (domain = TransactionHelper.getEditingDomain((Collection)selectedRepresentations)) != null) {
                DeleteRepresentationCommand command = new DeleteRepresentationCommand(domain, selectedRepresentations);
                domain.getCommandStack().execute((Command)command);
            }
        }
    }
}

