/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.actions;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.ui.dialogs.ResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.edit.ui.action.CommandActionHandler;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.mdsofa.common.helper.StringHelper;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.model.handler.provider.CapellaReadOnlyHelper;
import org.polarsys.capella.core.model.handler.provider.IReadOnlySectionHandler;
import org.polarsys.capella.core.sirius.ui.Messages;

public class ControlAction
extends CommandActionHandler {
    protected IStructuredSelection _selection;
    protected EObject _eObject;
    protected Resource _resource;
    protected boolean _canceled;

    public ControlAction() {
        this(null);
    }

    public ControlAction(EditingDomain domain) {
        super(domain, Messages.ControlAction__UI_Control_menu_item);
    }

    public boolean updateSelection(IStructuredSelection selection) {
        IReadOnlySectionHandler readOnlySectionHandler;
        this._selection = selection;
        if (this._selection.isEmpty()) {
            this.domain = null;
            this._eObject = null;
            this.command = null;
            return false;
        }
        Object object = AdapterFactoryEditingDomain.unwrap((Object)this._selection.getFirstElement());
        this.domain = TransactionUtil.getEditingDomain((Object)object);
        if (this.domain == null) {
            return false;
        }
        boolean result = this.domain.isControllable(object);
        EObject eObject = this._eObject = result ? (EObject)object : null;
        if (this._eObject != null && (readOnlySectionHandler = CapellaReadOnlyHelper.getReadOnlySectionHandler()) != null) {
            result &= readOnlySectionHandler.isControllable(this._eObject);
        }
        if (!AdapterFactoryEditingDomain.isControlled((Object)object)) {
            this.setText(Messages.ControlAction__UI_Control_menu_item);
            this.setDescription(Messages.ControlAction__UI_Control_menu_item_description);
            this.command = null;
        } else {
            this.setText(Messages.ControlAction__UI_Uncontrol_menu_item);
            this.setDescription(Messages.ControlAction__UI_Uncontrol_menu_item_description);
            if (result) {
                this.command = new RemoveCommand(this.domain, this._eObject.eResource().getContents(), (Object)this._eObject);
                this.command = new SelfAffectingCommand(Messages.ControlAction__UI_UncontrolCommand_label, this.command);
                result = this.command.canExecute();
            }
        }
        return result;
    }

    public void run() {
        if (this.command == null) {
            if (this._eObject == null) {
                return;
            }
            this._resource = this.getResource();
            if (this._resource == null) {
                this._canceled = true;
                return;
            }
            this.command = new AddCommand(this.domain, this._resource.getContents(), (Object)this._eObject);
            this.command = new SelfAffectingCommand(Messages.ControlAction__UI_ControlCommand_label, this.command);
        }
        EcoreUtil.resolveAll((ResourceSet)this.domain.getResourceSet());
        super.run();
    }

    protected Resource getResource() {
        ControlResourceDialog dialog = new ControlResourceDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.domain, this._eObject.eResource(), this._eObject);
        dialog.open();
        return dialog.getResource();
    }

    public void setActiveWorkbenchPart(IWorkbenchPart workbenchPart) {
        if (workbenchPart instanceof IEditingDomainProvider) {
            this.domain = ((IEditingDomainProvider)workbenchPart).getEditingDomain();
        }
    }

    protected static class ControlResourceDialog
    extends ResourceDialog {
        protected EditingDomain _domain;
        protected Resource _resource;
        protected Resource _currentResource;
        protected EObject _controledObject;

        public ControlResourceDialog(Shell parent, EditingDomain domain, Resource currentResource, EObject controledObject) {
            super(parent, Messages.ControlAction_Window_Title, 8192);
            this._domain = domain;
            this._currentResource = currentResource;
            this._controledObject = controledObject;
        }

        protected Control doCreateDialogArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
            layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(1808));
            ControlResourceDialog.applyDialogFont((Control)composite);
            Label resourceURILabel = new Label(composite, 0);
            resourceURILabel.setText(Messages.ControlAction_Label_Title);
            resourceURILabel.setLayoutData((Object)new GridData(32));
            this.uriField = new Text(composite, 2052);
            this.uriField.setLayoutData((Object)new GridData(768));
            return composite;
        }

        protected Control createDialogArea(Composite parent) {
            Control control = this.doCreateDialogArea(parent);
            StringBuilder defaultURI = new StringBuilder();
            defaultURI.append(URI.decode((String)this._controledObject.eResource().getURI().trimFileExtension().toString()));
            defaultURI.append('_');
            defaultURI.append(EMFCoreUtil.getName((EObject)this._controledObject));
            defaultURI.append('.');
            defaultURI.append("capellafragment");
            this.uriField.setText(URI.encodeFragment((String)defaultURI.toString(), (boolean)true));
            return control;
        }

        protected boolean processResources() {
            boolean resourceInSet;
            List uris = this.getURIs();
            if (uris.isEmpty()) {
                return false;
            }
            URI uri = (URI)uris.get(0);
            if (!CapellaResourceHelper.isCapellaFragment((URI)uri)) {
                String formattedMessage = StringHelper.formatMessage((String)Messages.ControlAction_Fragmentation_Error_Message, (Object[])new String[]{".capellafragment"});
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.ControlAction_Window_Title, (String)formattedMessage);
                return false;
            }
            ResourceSet resourceSet = this._domain.getResourceSet();
            Resource theResource = resourceSet.getResource(uri, false);
            boolean bl = resourceInSet = theResource != null;
            if (theResource == this._currentResource) {
                MessageDialog.openError((Shell)this.getShell(), (String)EMFEditUIPlugin.INSTANCE.getString("_UI_InvalidURI_label"), (String)EMFEditUIPlugin.INSTANCE.getString("_WARN_AlreadyInResource"));
                return false;
            }
            if (this._domain.isReadOnly(theResource)) {
                MessageDialog.openError((Shell)this.getShell(), (String)EMFEditUIPlugin.INSTANCE.getString("_UI_InvalidURI_label"), (String)EMFEditUIPlugin.INSTANCE.getString("_WARN_ReadOnlyResource"));
                return false;
            }
            boolean resourceExists = false;
            try {
                InputStream stream = resourceSet.getURIConverter().createInputStream(uri);
                if (stream != null) {
                    resourceExists = true;
                    stream.close();
                }
            }
            catch (IOException stream) {
                // empty catch block
            }
            boolean resourceBad = false;
            if (!resourceInSet) {
                theResource = resourceSet.createResource(uri);
                if (theResource == null) {
                    MessageDialog.openError((Shell)this.getShell(), (String)EMFEditUIPlugin.INSTANCE.getString("_UI_InvalidURI_label"), (String)EMFEditUIPlugin.INSTANCE.getString("_WARN_CannotCreateResource"));
                    return false;
                }
                if (resourceExists) {
                    try {
                        theResource = resourceSet.getResource(uri, true);
                    }
                    catch (RuntimeException exception) {
                        EMFEditUIPlugin.INSTANCE.log((Object)exception);
                        resourceBad = theResource.getContents().isEmpty();
                    }
                }
            }
            boolean result = true;
            if (resourceBad) {
                result = MessageDialog.openQuestion((Shell)this.getShell(), (String)EMFEditUIPlugin.INSTANCE.getString("_UI_ExistingResource_label"), (String)EMFEditUIPlugin.INSTANCE.getString("_WARN_ReplaceResource"));
            } else if (resourceExists) {
                result = MessageDialog.openQuestion((Shell)this.getShell(), (String)EMFEditUIPlugin.INSTANCE.getString("_UI_ExistingResource_label"), (String)EMFEditUIPlugin.INSTANCE.getString("_WARN_AddToResource"));
            }
            if (!result && !resourceInSet && theResource != null) {
                theResource.unload();
                resourceSet.getResources().remove((Object)theResource);
            } else {
                this._resource = theResource;
            }
            return result;
        }

        public Resource getResource() {
            return this._resource;
        }
    }

    protected class SelfAffectingCommand
    extends CommandWrapper {
        public SelfAffectingCommand(String label, Command command) {
            super(label, command);
        }

        public Collection<?> getResult() {
            return ControlAction.this._selection.toList();
        }

        public Collection<?> getAffectedObjects() {
            return ControlAction.this._selection.toList();
        }
    }
}

