/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.linkedtext.ui;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.polarsys.capella.common.linkedtext.ui.LinkedTextDocument;
import org.polarsys.capella.common.linkedtext.ui.LinkedTextHyperlink;
import org.polarsys.capella.common.model.label.LabelRetriever;

public class LinkedTextCompletionProposal
implements ICompletionProposal {
    private final String _displayString;
    private final IContextInformation _contextInformation;
    private final String _additionalProposalInfo;
    private final Object _target;
    private final int _startOffset;
    private final int _endOffset;
    private final ILabelProvider _labelProvider;

    public LinkedTextCompletionProposal(ILabelProvider labelProvider, Object target, int startOffset, int endOffset, IContextInformation contextInformation, String additionalProposalInfo) {
        this._labelProvider = labelProvider;
        this._contextInformation = contextInformation;
        this._additionalProposalInfo = additionalProposalInfo;
        this._target = target;
        this._startOffset = startOffset;
        this._endOffset = endOffset;
        this._displayString = this._target instanceof EObject ? LabelRetriever.getFullLabel((EObject)((EObject)this._target)) : null;
    }

    public void apply(IDocument document) {
        try {
            document.replace(this._startOffset, this._endOffset - this._startOffset, "");
            ((LinkedTextDocument)document).insertHyperlink(LinkedTextHyperlink.create(this._startOffset, this._labelProvider.getText(this._target).length(), this._target));
        }
        catch (BadLocationException exception) {
            exception.printStackTrace();
        }
    }

    public Point getSelection(IDocument document) {
        return new Point(this._startOffset + this._labelProvider.getText(this._target).length(), 0);
    }

    public IContextInformation getContextInformation() {
        return this._contextInformation;
    }

    public Image getImage() {
        return this._labelProvider.getImage(this._target);
    }

    public String getDisplayString() {
        return this._displayString != null ? this._displayString : this._labelProvider.getText(this._target);
    }

    public String getAdditionalProposalInfo() {
        return this._additionalProposalInfo;
    }
}

