/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.linkedtext.ui;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.polarsys.capella.common.linkedtext.ui.EmbeddedLinkedTextEditorConfiguration;
import org.polarsys.capella.common.linkedtext.ui.LinkedTextDocument;
import org.polarsys.capella.common.linkedtext.ui.LinkedTextHyperlink;

public class EmbeddedLinkedTextEditor {
    private SourceViewer sv;
    private LinkedTextDocument.Input _input;
    private LinkedTextDocument _document;
    private final String INITIAL_TEXT = "<Press key \"Ctrl+Space\" and type name for Content Assist>";
    private Color defaultTextColor;

    public EmbeddedLinkedTextEditor(Composite parent, int style) {
        this.sv = this.createSourceViewer(parent, style);
        this.sv.getTextWidget().addKeyListener((KeyListener)new InputKeyListener(this.sv));
        this.sv.getTextWidget().setAlwaysShowScrollBars(false);
        this.sv.getTextWidget().setToolTipText("<Press key \"Ctrl+Space\" and type name for Content Assist>");
        this.defaultTextColor = this.sv.getTextWidget().getForeground();
    }

    protected Color getHintColor() {
        return this.sv.getTextWidget().getDisplay().getSystemColor(16);
    }

    public void setInput(LinkedTextDocument.Input input) {
        if (this._input != null) {
            throw new IllegalStateException("Reuse of EmbeddedLinkedTextEditor instances is not yet supported");
        }
        this._input = input;
        this._document = LinkedTextDocument.load(this._input);
        this._document.addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                EmbeddedLinkedTextEditor.this.sv.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        String content = EmbeddedLinkedTextEditor.this._document.saveToRaw();
                        if (EmbeddedLinkedTextEditor.this._document.get().equals("<Press key \"Ctrl+Space\" and type name for Content Assist>")) {
                            return;
                        }
                        EmbeddedLinkedTextEditor.this._input.setText(content);
                    }
                });
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
        if (this._document.get().equals("")) {
            this.sv.getTextWidget().setForeground(this.getHintColor());
            this._document.set("<Press key \"Ctrl+Space\" and type name for Content Assist>");
        }
        this.sv.getTextWidget().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (EmbeddedLinkedTextEditor.this._document != null) {
                    EmbeddedLinkedTextEditor.this._document.dispose();
                }
            }
        });
        this.sv.getTextWidget().addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                if (EmbeddedLinkedTextEditor.this._document.get().equals("")) {
                    EmbeddedLinkedTextEditor.this.sv.getTextWidget().setForeground(EmbeddedLinkedTextEditor.this.getHintColor());
                    EmbeddedLinkedTextEditor.this._document.set("<Press key \"Ctrl+Space\" and type name for Content Assist>");
                }
            }

            public void focusGained(FocusEvent e) {
                if (EmbeddedLinkedTextEditor.this._document.get().equals("<Press key \"Ctrl+Space\" and type name for Content Assist>")) {
                    EmbeddedLinkedTextEditor.this.sv.getTextWidget().setForeground(EmbeddedLinkedTextEditor.this.defaultTextColor);
                    EmbeddedLinkedTextEditor.this._document.set("");
                }
            }
        });
        this.sv.setDocument((IDocument)this._document, (IAnnotationModel)new AnnotationModel());
        this.sv.invalidateTextPresentation();
    }

    protected SourceViewerConfiguration createSourceViewerConfiguration() {
        return new EmbeddedLinkedTextEditorConfiguration();
    }

    protected SourceViewer createSourceViewer(Composite parent, int styles) {
        final SourceViewer viewer = new SourceViewer(parent, null, null, true, styles);
        viewer.configure(this.createSourceViewerConfiguration());
        viewer.appendVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                LinkedTextHyperlink hl;
                if (event.keyCode == 8) {
                    LinkedTextHyperlink hl2 = EmbeddedLinkedTextEditor.this.getHyperlinkOverOrBeforeCaret(viewer);
                    if (hl2 != null) {
                        event.doit = false;
                        this.postDelete(hl2, event.display);
                    }
                } else if (event.keyCode == 127 && (hl = EmbeddedLinkedTextEditor.this.getHyperlinkOverOrAfterCaret(viewer)) != null) {
                    event.doit = false;
                    this.postDelete(hl, event.display);
                }
            }

            private void postDelete(final LinkedTextHyperlink hl, Display display) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            viewer.getDocument().replace(hl.getOffset(), hl.getLength(), "");
                        }
                        catch (BadLocationException exception) {
                            exception.printStackTrace();
                        }
                        hl.delete();
                    }
                });
            }
        });
        viewer.getTextWidget().addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                LinkedTextDocument doc = (LinkedTextDocument)((Object)viewer.getInput());
                for (LinkedTextHyperlink h : doc.getHyperlinks()) {
                    if (!h.overlapsWith(event.start, event.end - event.start) || event.start == event.end && h.getOffset() == event.start) continue;
                    event.doit = false;
                }
            }
        });
        return viewer;
    }

    private LinkedTextHyperlink getHyperlinkOverOrBeforeCaret(SourceViewer viewer) {
        LinkedTextDocument doc = (LinkedTextDocument)((Object)viewer.getInput());
        int caretOffset = viewer.getTextWidget().getCaretOffset();
        for (LinkedTextHyperlink h : doc.getHyperlinks()) {
            if (caretOffset <= h.getOffset() || caretOffset > h.getOffset() + h.getLength()) continue;
            return h;
        }
        return null;
    }

    private LinkedTextHyperlink getHyperlinkOverOrAfterCaret(SourceViewer viewer) {
        LinkedTextDocument doc = (LinkedTextDocument)((Object)viewer.getInput());
        int caretOffset = viewer.getTextWidget().getCaretOffset();
        for (LinkedTextHyperlink h : doc.getHyperlinks()) {
            if (caretOffset < h.getOffset() || caretOffset >= h.getOffset() + h.getLength()) continue;
            return h;
        }
        return null;
    }

    private LinkedTextHyperlink getHyperlinkOverCaret(SourceViewer viewer) {
        LinkedTextDocument doc = (LinkedTextDocument)((Object)viewer.getInput());
        int caretOffset = viewer.getTextWidget().getCaretOffset();
        for (LinkedTextHyperlink h : doc.getHyperlinks()) {
            if (caretOffset <= h.getOffset() || caretOffset >= h.getOffset() + h.getLength()) continue;
            return h;
        }
        return null;
    }

    public SourceViewer getSourceViewer() {
        return this.sv;
    }

    private class InputKeyListener
    implements KeyListener {
        final SourceViewer _sv;

        InputKeyListener(SourceViewer viewer) {
            this._sv = viewer;
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            switch (e.keyCode) {
                case 32: {
                    if ((e.stateMask & 0x40000) != 262144 || EmbeddedLinkedTextEditor.this.getHyperlinkOverCaret(this._sv) != null) break;
                    this._sv.doOperation(13);
                }
            }
        }
    }
}

