/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.interfaces.generateInterfaces;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.AbstractFunctionalBlock;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionInputPort;
import org.polarsys.capella.core.data.fa.FunctionOutputPort;
import org.polarsys.capella.core.data.fa.FunctionPort;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.model.helpers.FunctionalExchangeExt;
import org.polarsys.capella.core.model.helpers.PortExt;
import org.polarsys.capella.core.projection.interfaces.InterfaceGeneration;
import org.polarsys.capella.core.projection.interfaces.InterfaceGenerationPreferences;
import org.polarsys.capella.core.projection.interfaces.generateInterfaces.ComponentInterfaceAdapter;
import org.polarsys.capella.core.projection.interfaces.generateInterfaces.ComponentPortInterfaceAdapter;
import org.polarsys.capella.core.projection.interfaces.generateInterfaces.ExchangeTracing;
import org.polarsys.capella.core.projection.interfaces.generateInterfaces.InterfaceGenerationRule;
import org.polarsys.capella.core.projection.interfaces.generateInterfaces.InterfaceInfo;
import org.polarsys.capella.core.projection.interfaces.generateInterfaces.InterfaceProvider;
import org.polarsys.capella.core.projection.interfaces.generateInterfaces.InterfaceRequirer;
import org.polarsys.capella.core.projection.interfaces.generateInterfaces.TracingStrategy;
import org.polarsys.capella.core.tiger.ITransfo;

public class Rule_FunctionalExchange_Interface
extends InterfaceGenerationRule {
    private final TracingStrategy tracingStrategy = new ExchangeTracing();
    static final String KEY_INTERFACEINFO_MAP = "org.polarsys.capella.core.projection.interfaces.generateInterfaces.INFOMAP";

    public Rule_FunctionalExchange_Interface() {
        super(FaPackage.Literals.FUNCTIONAL_EXCHANGE, CsPackage.Literals.INTERFACE);
    }

    @Override
    protected Collection<InterfaceInfo> transformToInterfaceInfo(EObject element, ITransfo transfo) {
        InterfaceGenerationPreferences prefs;
        InterfaceInfo info = this.getInterfaceInfo((FunctionalExchange)element, transfo);
        if (info != null && info.getExchangeItems(prefs = InterfaceGeneration.getPreferences(transfo)).size() > 0) {
            return Collections.singleton(info);
        }
        return Collections.emptyList();
    }

    private Collection<InterfaceInfo> getInterfaceInfo(FunctionalExchange exchange) {
        LinkedHashSet<InterfaceInfo> result = new LinkedHashSet<InterfaceInfo>();
        AbstractFunction sourceFunction = FunctionalExchangeExt.getSourceFunction((FunctionalExchange)exchange);
        AbstractFunction targetFunction = FunctionalExchangeExt.getTargetFunction((FunctionalExchange)exchange);
        for (ComponentExchange ce : exchange.getAllocatingComponentExchanges()) {
            ComponentPort leftPort = (ComponentPort)ce.getSourcePort();
            ComponentPort rightPort = (ComponentPort)ce.getTargetPort();
            if (leftPort == null || rightPort == null || sourceFunction == null || targetFunction == null) continue;
            ComponentPort providing = null;
            ComponentPort requiring = null;
            Component leftComponent = PortExt.getRelatedComponent((ComponentPort)leftPort);
            Component rightComponent = PortExt.getRelatedComponent((ComponentPort)rightPort);
            if (leftComponent.getAllocatedFunctions().contains((Object)sourceFunction) && rightComponent.getAllocatedFunctions().contains((Object)targetFunction)) {
                requiring = leftPort;
                providing = rightPort;
            } else if (rightComponent.getAllocatedFunctions().contains((Object)sourceFunction) && leftComponent.getAllocatedFunctions().contains((Object)targetFunction)) {
                requiring = rightPort;
                providing = leftPort;
            }
            if (providing == null || requiring == null || providing == requiring) continue;
            result.add(new InterfaceInfo(new ComponentPortInterfaceAdapter(providing), new ComponentPortInterfaceAdapter(requiring), this.tracingStrategy));
        }
        FunctionInputPort fip = exchange.getTargetFunctionInputPort();
        FunctionOutputPort fop = exchange.getSourceFunctionOutputPort();
        if (fip != null && fop != null) {
            Collection allRequiring = this.analyzePort(sourceFunction, (FunctionPort)fop, result.isEmpty());
            Collection allProviding = this.analyzePort(targetFunction, (FunctionPort)fip, result.isEmpty());
            for (InterfaceRequirer requiring : allRequiring) {
                for (InterfaceProvider providing : allProviding) {
                    if (providing == requiring) continue;
                    result.add(new InterfaceInfo(providing, requiring, this.tracingStrategy));
                }
            }
        }
        return result;
    }

    private <T> Collection<T> analyzePort(AbstractFunction f, FunctionPort port, boolean createComponentInterfaceAdapter) {
        ArrayList<InterfaceProvider> result = new ArrayList<InterfaceProvider>();
        for (ComponentPort p : port.getAllocatorComponentPorts()) {
            result.add(new ComponentPortInterfaceAdapter(p));
        }
        if (result.isEmpty() && createComponentInterfaceAdapter) {
            for (AbstractFunctionalBlock allocator : f.getAllocationBlocks()) {
                if (!(allocator instanceof Component)) continue;
                result.add(new ComponentInterfaceAdapter((Component)allocator));
            }
        }
        return result;
    }

    private static Map<FunctionalExchange, InterfaceInfo> getInfoMap(ITransfo transfo) {
        HashMap map = (HashMap)transfo.get((Object)KEY_INTERFACEINFO_MAP);
        if (map == null) {
            map = new HashMap();
            transfo.put((Object)KEY_INTERFACEINFO_MAP, map);
        }
        return map;
    }

    private void logMultipleInfosFound(EObject exchange, ITransfo transfo) {
        if (!transfo.isDryRun()) {
            this._logger.error((Object)new EmbeddedMessage("Skipping generation for functional exchange " + EObjectLabelProviderHelper.getText((Object)exchange) + " which has inconsistent or multiple port/ce allocations", this._logger.getName(), (Object)exchange));
        }
    }

    private void logNoInfosFound(EObject element) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug((Object)new EmbeddedMessage("Skipping generation for internal functional exchange " + EObjectLabelProviderHelper.getText((Object)element), this._logger.getName(), (Object)element));
        }
    }

    public static Interface getInterface(FunctionalExchange exchange, ITransfo transfo) {
        Interface result = null;
        InterfaceInfo info = Rule_FunctionalExchange_Interface.getInfoMap(transfo).get(exchange);
        if (info != null) {
            result = info.getInterface(false);
        }
        return result;
    }

    InterfaceInfo getInterfaceInfo(FunctionalExchange element, ITransfo transfo) {
        Map<FunctionalExchange, InterfaceInfo> infomap = Rule_FunctionalExchange_Interface.getInfoMap(transfo);
        InterfaceInfo result = null;
        if (infomap.containsKey(element)) {
            result = Rule_FunctionalExchange_Interface.getInfoMap(transfo).get(element);
        } else {
            Collection<InterfaceInfo> infos = this.getInterfaceInfo(element);
            if (infos.size() == 1) {
                result = infos.iterator().next();
                for (FunctionalExchange exchange : result.getFunctionalExchanges()) {
                    infomap.put(exchange, result);
                }
            } else if (infos.isEmpty()) {
                this.logNoInfosFound((EObject)element);
            } else {
                this.logMultipleInfosFound((EObject)element, transfo);
            }
            infomap.put(element, result);
        }
        return result;
    }
}

