/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.test.move;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.move.MoveHelper;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;
import org.polarsys.capella.cybersecurity.model.CybersecurityFactory;
import org.polarsys.capella.cybersecurity.model.CybersecurityPkg;
import org.polarsys.capella.cybersecurity.model.FunctionalPrimaryAsset;
import org.polarsys.capella.cybersecurity.model.Threat;
import org.polarsys.capella.cybersecurity.sirius.analysis.CybersecurityServices;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.helpers.GuiActions;

public abstract class AbstractCybersecurityMoveTest
extends BasicTestCase {
    protected Project project;
    protected BlockArchitecture oaArch;
    protected BlockArchitecture saArch;
    protected BlockArchitecture laArch;
    protected BlockArchitecture paArch;
    protected CybersecurityPkg oaPkg;
    protected CybersecurityPkg saPkg;
    protected CybersecurityPkg laPkg;
    protected CybersecurityPkg paPkg;
    protected SessionContext context;
    protected Threat threatSASub;
    protected FunctionalPrimaryAsset fpaSASub;
    protected CybersecurityPkg subSAPkg;
    protected CybersecurityPkg subSAPkg1;
    protected Threat threatSASub1;
    public static final String THREAT1_SA = "100b227c-6b62-4875-aded-7eeaddf8cba9";
    public static final String FPA1_SA = "Id c9e3c8d2-5c36-4832-81bd-b836dea7e63b";
    public static final String CYBERSECURITY_CONFIGURATION = "b2ddab1d-4f42-41f3-b1e7-27d6e8408786";
    protected CybersecurityServices services;
    protected TransactionalEditingDomain ted;

    protected void init() {
        Session session = this.getSession(this.getRequiredTestModels().get(0));
        this.ted = session.getTransactionalEditingDomain();
        this.context = new SessionContext(session);
        this.project = SessionHelper.getCapellaProject((Session)session);
        this.services = new CybersecurityServices();
        this.oaArch = BlockArchitectureExt.getBlockArchitecture((BlockArchitectureExt.Type)BlockArchitectureExt.Type.OA, (Project)this.project);
        this.saArch = BlockArchitectureExt.getBlockArchitecture((BlockArchitectureExt.Type)BlockArchitectureExt.Type.SA, (Project)this.project);
        this.laArch = BlockArchitectureExt.getBlockArchitecture((BlockArchitectureExt.Type)BlockArchitectureExt.Type.LA, (Project)this.project);
        this.paArch = BlockArchitectureExt.getBlockArchitecture((BlockArchitectureExt.Type)BlockArchitectureExt.Type.PA, (Project)this.project);
        this.oaPkg = this.services.getRootCibersecurityPkg(this.oaArch);
        this.saPkg = this.services.getRootCibersecurityPkg(this.saArch);
        this.laPkg = this.services.getRootCibersecurityPkg(this.laArch);
        this.paPkg = this.services.getRootCibersecurityPkg(this.paArch);
        AbstractReadWriteCommand cmd = new AbstractReadWriteCommand(){

            public void run() {
                AbstractCybersecurityMoveTest.this.subSAPkg = CybersecurityFactory.eINSTANCE.createCybersecurityPkg();
                AbstractCybersecurityMoveTest.this.saPkg.getOwnedCybersecurityPkgs().add((Object)AbstractCybersecurityMoveTest.this.subSAPkg);
                AbstractCybersecurityMoveTest.this.subSAPkg1 = CybersecurityFactory.eINSTANCE.createCybersecurityPkg();
                AbstractCybersecurityMoveTest.this.subSAPkg.getOwnedCybersecurityPkgs().add((Object)AbstractCybersecurityMoveTest.this.subSAPkg1);
                AbstractCybersecurityMoveTest.this.threatSASub = AbstractCybersecurityMoveTest.this.services.createThreatInPkg(AbstractCybersecurityMoveTest.this.subSAPkg);
                AbstractCybersecurityMoveTest.this.subSAPkg.getOwnedThreats().add((Object)AbstractCybersecurityMoveTest.this.threatSASub);
                AbstractCybersecurityMoveTest.this.threatSASub1 = AbstractCybersecurityMoveTest.this.services.createThreatInPkg(AbstractCybersecurityMoveTest.this.subSAPkg1);
                AbstractCybersecurityMoveTest.this.subSAPkg1.getOwnedThreats().add((Object)AbstractCybersecurityMoveTest.this.threatSASub1);
                AbstractCybersecurityMoveTest.this.fpaSASub = AbstractCybersecurityMoveTest.this.services.createFunctionalPrimaryAssetInPkg(AbstractCybersecurityMoveTest.this.subSAPkg);
                AbstractCybersecurityMoveTest.this.subSAPkg.getOwnedPrimaryAssets().add((Object)AbstractCybersecurityMoveTest.this.fpaSASub);
            }
        };
        TransactionHelper.getExecutionManager((Session)session).execute((ICommand)cmd);
    }

    public List<String> getRequiredTestModels() {
        return Collections.singletonList("CybersecurityModel");
    }

    protected void checkMoveDisabled(EObject current, EObject newTarget, String rule) {
        AbstractCybersecurityMoveTest.assertTrue((String)("Move shall be disabled: " + rule), (!MoveHelper.getInstance().checkSemanticRules(Arrays.asList(current), newTarget).isOK() ? 1 : 0) != 0);
    }

    void checkMoveAllowed(EObject current, EObject newTarget, String rule) {
        AbstractCybersecurityMoveTest.assertTrue((String)("Move shall be allowed: " + rule), (boolean)MoveHelper.getInstance().checkSemanticRules(Arrays.asList(current), newTarget).isOK());
    }

    protected void checkCopyDisabled(EObject current, EObject newTarget, String rule) {
        try {
            GuiActions.copyElement((String)" ", (EObject)current);
            AbstractCybersecurityMoveTest.assertTrue((String)("Copy shall be disabled: " + rule), (!GuiActions.canPasteElement((String)" ", (EObject)newTarget) ? 1 : 0) != 0);
            System.out.println();
        }
        catch (Exception e) {
            AbstractCybersecurityMoveTest.assertTrue((String)e.getMessage(), (boolean)false);
        }
    }
}

