/*******************************************************************************
 * Copyright (c) 2019 THALES GLOBAL SERVICES.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0
 *
 * SPDX-License-Identifier: EPL-2.0
 *   
 * Contributors:
 *    Thales - initial API and implementation
 *******************************************************************************/

// Generated on 20.05.2019 at 12:52:47 CEST by Viewpoint DSL Generator V 0.1

package org.polarsys.capella.cybersecurity.ui.properties.sections;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.polarsys.capella.common.mdsofa.common.constant.ICommonConstants;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticField;
import org.polarsys.capella.core.ui.properties.fields.TextAreaValueGroup;
import org.polarsys.capella.core.ui.properties.fields.TextValueGroup;
import org.polarsys.capella.core.ui.properties.sections.AbstractSection;
import org.polarsys.capella.cybersecurity.model.CybersecurityPackage;
import org.polarsys.capella.cybersecurity.model.TrustBoundaryStorage;
import org.polarsys.capella.cybersecurity.ui.CommonHelpers;
import org.polarsys.capella.cybersecurity.ui.CybersecurityUIActivator;
import org.polarsys.capella.cybersecurity.ui.ElementExtensionStorage;
import org.polarsys.capella.cybersecurity.ui.properties.fields.IntegerValueRadioGroup;
import org.polarsys.capella.cybersecurity.ui.properties.fields.SemanticCheckboxGroup;

/**
 * <!-- begin-user-doc --> This class is an implementation of the section
 * '<em><b>[Cyber_ActorAttributes_cyber_ActorAttributes_Section]</b></em>'. <!-- end-user-doc -->
 * <p>
 * </p>
 *
 * @generated
 */

public class ActorCybersecuritySection extends AbstractSection {

  // display properties for this element
  private TrustBoundaryStorage elementExtension;

  private SemanticCheckboxGroup checkBoxes;

  private IntegerValueRadioGroup threatSourceProfileGroup;
  private TextValueGroup rationaleGroup;

  /**
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * 
   * @param eObject:
   *          current object
   * @generated
   */
  public boolean select(Object eObject) {
    EObject eObjectToTest = super.selection(eObject);

    if (eObjectToTest == null) {
      return false;
    } else if (eObjectToTest instanceof TrustBoundaryStorage) {
      return true;
    } else {
      EObject children = getTrustBoundaryStorageObject(eObjectToTest);
      if (children != null) {
        return true;
      }
    }

    return false;
  }

  /**
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * 
   * @param part
   * @param selection
   * @generated
   */
  public void setInput(IWorkbenchPart part, ISelection selection) {
    EObject newEObject = super.setInputSelection(part, selection);

    if (newEObject != null && !(newEObject instanceof TrustBoundaryStorage)) {
      newEObject = getTrustBoundaryStorageObject(newEObject);
    }

    if (newEObject != null) {
      loadData(newEObject);
    }
  }

  /**
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * 
   * @param parent:
   *          An EObject. It is considered as the Parent of an EMDE extension (a Viewpoint element)
   * @return
   * @generated
   */
  private EObject getTrustBoundaryStorageObject(EObject parent) {
    if (parent == null)
      return null;

    if (!CommonHelpers.isViewpointActive(parent, CybersecurityUIActivator.VIEWPOINT_ID))
      return null;
    
    return ElementExtensionStorageHelper.getFirstElementExtensionStorageObject(parent, TrustBoundaryStorage.class, CybersecurityPackage.Literals.TRUST_BOUNDARY_STORAGE);
  }

  /**
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * 
   * @param parent:
   * @param aTabbedPropertySheetPage:
   * @generated
   */
  public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
    super.createControls(parent, aTabbedPropertySheetPage);


    Group checkGroup = getWidgetFactory().createGroup(rootParentComposite, ICommonConstants.EMPTY_STRING);
    checkGroup.setLayout(new GridLayout(2, false));
    checkGroup.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

    checkBoxes = new SemanticCheckboxGroup(checkGroup, getWidgetFactory());
    checkBoxes.addCheckbox(CybersecurityPackage.Literals.TRUST_BOUNDARY_STORAGE__TRUSTED,
        e -> !((TrustBoundaryStorage) e).isThreatSource());
    checkBoxes.addCheckbox(CybersecurityPackage.Literals.TRUST_BOUNDARY_STORAGE__THREAT_SOURCE,
        (e) -> {
          EObject container = ElementExtensionStorage.findContainer(e);
          return container instanceof Component && (((Component)container).isActor() || container instanceof Entity);
        });

    threatSourceProfileGroup = new IntegerValueRadioGroup(rootParentComposite, Messages.ActorCybersecuritySection_0, getWidgetFactory(), 1, 5);
    rationaleGroup = new TextAreaValueGroup(rootParentComposite, Messages.ActorCybersecuritySection_1, getWidgetFactory());

    CybersecurityPropertyButtonListener.getCybersecurityPropertyListener().registerPropertySection(this);
  }

  /**
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * 
   * @param object
   * @generated
   */
  public void loadData(EObject object) {
    super.loadData(object);
    checkBoxes.loadData(object);
    threatSourceProfileGroup.loadData(object,
        CybersecurityPackage.Literals.TRUST_BOUNDARY_STORAGE__THREAT_SOURCE_PROFILE);
    rationaleGroup.loadData(object, CybersecurityPackage.Literals.TRUST_BOUNDARY_STORAGE__RATIONALE);
    elementExtension = (TrustBoundaryStorage) object;
    threatSourceProfileGroup.setEnabled(object.eContainer() instanceof Component
        && (((Component) object.eContainer()).isActor() || object.eContainer() instanceof Entity) && !elementExtension.isTrusted());
    if (elementExtension.isTrusted()) {
      threatSourceProfileGroup.getSemanticFields()
          .forEach((Consumer<? super Button>) button -> button.setSelection(false));
    }
  }

  /**
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generated
   */
  public List<AbstractSemanticField> getSemanticFields() {
    List<AbstractSemanticField> abstractSemanticFields = new ArrayList<AbstractSemanticField>();
    abstractSemanticFields.add(checkBoxes);
    abstractSemanticFields.add(threatSourceProfileGroup);
    abstractSemanticFields.add(rationaleGroup);
    return abstractSemanticFields;
  }

  /**
   * @see org.eclipse.ui.views.properties.tabbed.AbstractPropertySection#refresh()
   */
  @Override
  public void refresh() {
    // must be overwritten since we can also load data from objects without a resource
    if (elementExtension != null) {
      loadData(elementExtension);
    }
  }

  @Override
  public void dispose() {
    super.dispose();
    CybersecurityPropertyButtonListener.getCybersecurityPropertyListener().unregisterPropertySection(this);
  }

}
